/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseForkBuilder;
import io.hyperfoil.api.config.PhaseReference;
import io.hyperfoil.api.config.RelativeIteration;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.function.SerializableSupplier;
import io.hyperfoil.impl.FutureSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class PhaseBuilder<PB extends PhaseBuilder<PB>> {
    protected final String name;
    protected final BenchmarkBuilder parent;
    protected long startTime = -1L;
    protected Collection<PhaseReference> startAfter = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> startAfterStrict = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> terminateAfterStrict = new ArrayList<PhaseReference>();
    protected long duration = -1L;
    protected long maxDuration = -1L;
    protected int maxIterations = 1;
    protected boolean forceIterations = false;
    protected List<PhaseForkBuilder> forks = new ArrayList<PhaseForkBuilder>();

    protected PhaseBuilder(BenchmarkBuilder parent, String name) {
        this.name = name;
        this.parent = parent;
        parent.addPhase(name, this);
    }

    public static Phase.Noop noop(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String iterationName, List<String> startAfter, List<String> startAfterStrict, List<String> terminateAfterStrict) {
        FutureSupplier<Phase.Noop> ps = new FutureSupplier<Phase.Noop>();
        Scenario scenario = new Scenario(new Sequence[0], new Sequence[0], new String[0], new String[0], 0, 0);
        Phase.Noop phase = new Phase.Noop(benchmark, id, iteration, iterationName, startAfter, startAfterStrict, terminateAfterStrict, scenario);
        ps.set(phase);
        return phase;
    }

    public BenchmarkBuilder endPhase() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public ScenarioBuilder scenario() {
        if (this.forks.isEmpty()) {
            PhaseForkBuilder fork = new PhaseForkBuilder(this, null);
            this.forks.add(fork);
            return fork.scenario;
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " already set!");
        }
        throw new BenchmarkDefinitionException("Scenario is forked; you need to specify another fork.");
    }

    private PB self() {
        return (PB)this;
    }

    public PhaseForkBuilder fork(String name) {
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + name + " already set!");
        }
        PhaseForkBuilder fork = new PhaseForkBuilder(this, name);
        this.forks.add(fork);
        return fork;
    }

    public PB startTime(long startTime) {
        this.startTime = startTime;
        return this.self();
    }

    public PB startAfter(String phase) {
        this.startAfter.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfter(PhaseReference phase) {
        this.startAfter.add(phase);
        return this.self();
    }

    public PB startAfterStrict(String phase) {
        this.startAfterStrict.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfterStrict(PhaseReference phase) {
        this.startAfterStrict.add(phase);
        return this.self();
    }

    public PB duration(long duration) {
        this.duration = duration;
        return this.self();
    }

    public PB maxDuration(long maxDuration) {
        this.maxDuration = maxDuration;
        return this.self();
    }

    public PB maxIterations(int iterations) {
        this.maxIterations = iterations;
        return this.self();
    }

    public void prepareBuild() {
        this.forks.forEach(fork -> fork.scenario.prepareBuild());
    }

    public Collection<Phase> build(SerializableSupplier<Benchmark> benchmark, AtomicInteger idCounter) {
        if (this.forks.isEmpty()) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " is not defined.");
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name != null) {
            throw new BenchmarkDefinitionException(this.name + " has single fork: define scenario directly.");
        }
        boolean hasForks = this.forks.size() > 1;
        this.forks.removeIf(fork -> fork.weight <= 0.0);
        double sumWeight = this.forks.stream().mapToDouble(f -> f.weight).sum();
        this.forks.forEach(f -> f.weight /= sumWeight);
        List<Phase> phases = IntStream.range(0, this.maxIterations).mapToObj(iteration -> this.forks.stream().map(f -> this.buildPhase(benchmark, idCounter.getAndIncrement(), iteration, (PhaseForkBuilder)f))).flatMap(Function.identity()).collect(Collectors.toList());
        if (this.maxIterations > 1 || this.forceIterations) {
            if (hasForks) {
                IntStream.range(0, this.maxIterations).mapToObj(iteration -> {
                    String iterationName = this.formatIteration(this.name, iteration);
                    List<String> forks = this.forks.stream().map(f -> iterationName + "/" + f.name).collect(Collectors.toList());
                    return PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), iteration, iterationName, forks, Collections.emptyList(), forks);
                }).forEach(phases::add);
            }
            List<String> lastIteration = Collections.singletonList(this.formatIteration(this.name, this.maxIterations - 1));
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), 0, this.name, lastIteration, Collections.emptyList(), lastIteration));
        } else if (hasForks) {
            List<String> forks = this.forks.stream().map(f -> this.name + "/" + f.name).collect(Collectors.toList());
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), 0, this.name, forks, Collections.emptyList(), forks));
        }
        return phases;
    }

    protected abstract Phase buildPhase(SerializableSupplier<Benchmark> var1, int var2, int var3, PhaseForkBuilder var4);

    String iterationName(int iteration, String forkName) {
        if (this.maxIterations == 1 && !this.forceIterations) {
            assert (iteration == 0);
            if (forkName == null) {
                return this.name;
            }
            return this.name + "/" + forkName;
        }
        String iterationName = this.formatIteration(this.name, iteration);
        if (forkName == null) {
            return iterationName;
        }
        return iterationName + "/" + forkName;
    }

    private String formatIteration(String name, int iteration) {
        return String.format("%s/%03d", name, iteration);
    }

    long iterationStartTime(int iteration) {
        return iteration == 0 ? this.startTime : -1L;
    }

    String sharedResources(PhaseForkBuilder fork) {
        if (fork == null || fork.name == null) {
            return this.name;
        }
        return this.name + "/" + fork.name;
    }

    Collection<String> iterationReferences(Collection<PhaseReference> refs, int iteration, boolean addSelfPrevious) {
        ArrayList<String> names = new ArrayList<String>();
        block5: for (PhaseReference ref : refs) {
            if (ref.iteration != RelativeIteration.NONE && this.maxIterations <= 1 && !this.forceIterations) {
                String msg = "Phase " + this.name + " tries to reference " + ref.phase + "/" + ref.iteration + (String)(ref.fork == null ? "" : "/" + ref.fork) + " but this phase does not have any iterations (cannot determine relative iteration).";
                throw new BenchmarkDefinitionException(msg);
            }
            switch (ref.iteration) {
                case NONE: {
                    names.add(ref.phase);
                    continue block5;
                }
                case PREVIOUS: {
                    if (iteration <= 0) continue block5;
                    names.add(this.formatIteration(ref.phase, iteration - 1));
                    continue block5;
                }
                case SAME: {
                    names.add(this.formatIteration(ref.phase, iteration));
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
        if (addSelfPrevious && iteration > 0) {
            names.add(this.formatIteration(this.name, iteration - 1));
        }
        return names;
    }

    public void readForksFrom(PhaseBuilder<?> other) {
        for (PhaseForkBuilder builder : other.forks) {
            this.fork(builder.name).readFrom(builder);
        }
    }

    public PB forceIterations(boolean force) {
        this.forceIterations = force;
        return this.self();
    }

    public static class Catalog {
        private final BenchmarkBuilder parent;
        private final String name;

        Catalog(BenchmarkBuilder parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public AtOnce atOnce(int users) {
            return new AtOnce(this.parent, this.name, users);
        }

        public Always always(int users) {
            return new Always(this.parent, this.name, users);
        }

        public RampRate rampRate(int initialUsersPerSec, int targetUsersPerSec) {
            return new RampRate(this.parent, this.name, initialUsersPerSec, targetUsersPerSec);
        }

        public ConstantRate constantRate(int usersPerSec) {
            return new ConstantRate(this.parent, this.name, usersPerSec);
        }

        public Sequentially sequentially(int repeats) {
            return new Sequentially(this.parent, this.name, repeats);
        }
    }

    public static class Sequentially
    extends PhaseBuilder<Sequentially> {
        private int repeats;

        protected Sequentially(BenchmarkBuilder parent, String name, int repeats) {
            super(parent, name);
            this.repeats = repeats;
        }

        @Override
        protected Phase buildPhase(SerializableSupplier<Benchmark> benchmark, int id, int i, PhaseForkBuilder f) {
            if (this.repeats <= 0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".repeats must be positive");
            }
            return new Phase.Sequentially(benchmark, id, i, this.iterationName(i, f.name), f.scenario().build(), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, this.sharedResources(f), this.repeats);
        }
    }

    public static class ConstantRate
    extends OpenModel<ConstantRate> {
        private double usersPerSec;
        private double usersPerSecIncrement;

        ConstantRate(BenchmarkBuilder parent, String name, double usersPerSec) {
            super(parent, name);
            this.usersPerSec = usersPerSec;
        }

        @Override
        public Phase.ConstantRate buildPhase(SerializableSupplier<Benchmark> benchmark, int id, int i, PhaseForkBuilder f) {
            int maxSessions = this.maxSessions <= 0 ? (int)Math.ceil(f.weight * (this.usersPerSec + this.usersPerSecIncrement * (double)(this.maxIterations - 1))) : (int)Math.round((double)this.maxSessions * f.weight);
            if (this.usersPerSec <= 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".usersPerSec must be positive.");
            }
            return new Phase.ConstantRate(benchmark, id, i, this.iterationName(i, f.name), f.scenario.build(), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, this.sharedResources(f), (this.usersPerSec + this.usersPerSecIncrement * (double)i) * f.weight, this.variance, maxSessions, this.sessionLimitPolicy);
        }

        public ConstantRate usersPerSec(double usersPerSec) {
            this.usersPerSec = usersPerSec;
            return this;
        }

        public ConstantRate usersPerSec(double base, double increment) {
            this.usersPerSec = base;
            this.usersPerSecIncrement = increment;
            return this;
        }
    }

    public static class RampRate
    extends OpenModel<RampRate> {
        private double initialUsersPerSec;
        private double initialUsersPerSecIncrement;
        private double targetUsersPerSec;
        private double targetUsersPerSecIncrement;
        private Predicate<Phase.RampRate> constraint;
        private String constraintMessage;

        RampRate(BenchmarkBuilder parent, String name, double initialUsersPerSec, double targetUsersPerSec) {
            super(parent, name);
            this.initialUsersPerSec = initialUsersPerSec;
            this.targetUsersPerSec = targetUsersPerSec;
        }

        @Override
        public Phase.RampRate buildPhase(SerializableSupplier<Benchmark> benchmark, int id, int i, PhaseForkBuilder f) {
            int maxSessions;
            if (this.maxSessions > 0) {
                maxSessions = (int)Math.round((double)this.maxSessions * f.weight);
            } else {
                double maxInitialUsers = this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)(this.maxIterations - 1);
                double maxTargetUsers = this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)(this.maxIterations - 1);
                maxSessions = (int)Math.ceil(Math.max(maxInitialUsers, maxTargetUsers) * f.weight);
            }
            if (this.initialUsersPerSec < 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".initialUsersPerSec must be non-negative");
            }
            if (this.targetUsersPerSec < 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".targetUsersPerSec must be non-negative");
            }
            if (this.initialUsersPerSec < 1.0E-4 && this.targetUsersPerSec < 1.0E-4) {
                throw new BenchmarkDefinitionException("In phase " + this.name + " both initialUsersPerSec and targetUsersPerSec are 0");
            }
            Phase.RampRate rampRate = new Phase.RampRate(benchmark, id, i, this.iterationName(i, f.name), f.scenario.build(), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, this.sharedResources(f), (this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)i) * f.weight, (this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)i) * f.weight, this.variance, maxSessions, this.sessionLimitPolicy);
            if (this.constraint != null && !this.constraint.test(rampRate)) {
                throw new BenchmarkDefinitionException("Phase " + this.name + " failed constraints: " + this.constraintMessage);
            }
            return rampRate;
        }

        public RampRate initialUsersPerSec(double initialUsersPerSec) {
            this.initialUsersPerSec = initialUsersPerSec;
            this.initialUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampRate initialUsersPerSec(double base, double increment) {
            this.initialUsersPerSec = base;
            this.initialUsersPerSecIncrement = increment;
            return this;
        }

        public RampRate targetUsersPerSec(double targetUsersPerSec) {
            this.targetUsersPerSec = targetUsersPerSec;
            this.targetUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampRate targetUsersPerSec(double base, double increment) {
            this.targetUsersPerSec = base;
            this.targetUsersPerSecIncrement = increment;
            return this;
        }

        public RampRate constraint(Predicate<Phase.RampRate> constraint, String constraintMessage) {
            this.constraint = constraint;
            this.constraintMessage = constraintMessage;
            return this;
        }
    }

    public static abstract class OpenModel<P extends PhaseBuilder<P>>
    extends PhaseBuilder<P> {
        protected int maxSessions;
        protected boolean variance = true;
        protected Phase.SessionLimitPolicy sessionLimitPolicy = Phase.SessionLimitPolicy.FAIL;

        protected OpenModel(BenchmarkBuilder parent, String name) {
            super(parent, name);
        }

        public P maxSessions(int maxSessions) {
            this.maxSessions = maxSessions;
            return (P)this;
        }

        public P variance(boolean variance) {
            this.variance = variance;
            return (P)this;
        }

        public P sessionLimitPolicy(Phase.SessionLimitPolicy sessionLimitPolicy) {
            this.sessionLimitPolicy = sessionLimitPolicy;
            return (P)this;
        }
    }

    public static class Always
    extends PhaseBuilder<Always> {
        private int users;
        private int usersIncrement;

        Always(BenchmarkBuilder parent, String name, int users) {
            super(parent, name);
            this.users = users;
        }

        @Override
        public Phase.Always buildPhase(SerializableSupplier<Benchmark> benchmark, int id, int i, PhaseForkBuilder f) {
            if (this.users <= 0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".users must be positive.");
            }
            return new Phase.Always(benchmark, id, i, this.iterationName(i, f.name), f.scenario.build(), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, this.sharedResources(f), (int)Math.round((double)(this.users + this.usersIncrement * i) * f.weight));
        }

        public Always users(int users) {
            this.users = users;
            return this;
        }

        public Always users(int base, int increment) {
            this.users = base;
            this.usersIncrement = increment;
            return this;
        }
    }

    public static class AtOnce
    extends PhaseBuilder<AtOnce> {
        private int users;
        private int usersIncrement;

        AtOnce(BenchmarkBuilder parent, String name, int users) {
            super(parent, name);
            this.users = users;
        }

        public AtOnce users(int users) {
            this.users = users;
            return this;
        }

        public AtOnce users(int base, int increment) {
            this.users = base;
            this.usersIncrement = increment;
            return this;
        }

        @Override
        public Phase.AtOnce buildPhase(SerializableSupplier<Benchmark> benchmark, int id, int i, PhaseForkBuilder f) {
            if (this.users <= 0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".users must be positive.");
            }
            return new Phase.AtOnce(benchmark, id, i, this.iterationName(i, f.name), f.scenario.build(), this.iterationStartTime(i), this.iterationReferences(this.startAfter, i, false), this.iterationReferences(this.startAfterStrict, i, true), this.iterationReferences(this.terminateAfterStrict, i, false), this.duration, this.maxDuration, this.sharedResources(f), (int)Math.round((double)(this.users + this.usersIncrement * i) * f.weight));
        }
    }
}

