/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Sequence;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Scenario
implements Serializable {
    private final Sequence[] initialSequences;
    private final Sequence[] sequences;
    private final String[] objectVars;
    private final String[] intVars;
    private final Map<String, Sequence> sequenceMap;
    private final int maxRequests;
    private final int maxSequences;
    private final int sumConcurrency;

    public Scenario(Sequence[] initialSequences, Sequence[] sequences, String[] objectVars, String[] intVars, int maxRequests, int maxSequences) {
        this.initialSequences = initialSequences;
        this.sequences = sequences;
        this.objectVars = objectVars;
        this.intVars = intVars;
        this.maxRequests = maxRequests;
        this.maxSequences = maxSequences;
        this.sequenceMap = Stream.of(sequences).collect(Collectors.toMap(Sequence::name, Function.identity()));
        this.sumConcurrency = this.sequenceMap.values().stream().mapToInt(Sequence::concurrency).sum();
    }

    public Sequence[] initialSequences() {
        return this.initialSequences;
    }

    public Sequence[] sequences() {
        return this.sequences;
    }

    public String[] objectVars() {
        return this.objectVars;
    }

    public String[] intVars() {
        return this.intVars;
    }

    public int maxRequests() {
        return this.maxRequests;
    }

    public int maxSequences() {
        return this.maxSequences;
    }

    public int sumConcurrency() {
        return this.sumConcurrency;
    }

    public Sequence sequence(String name) {
        Sequence sequence = this.sequenceMap.get(name);
        if (sequence == null) {
            throw new IllegalArgumentException("Unknown sequence '" + name + "'");
        }
        return sequence;
    }
}

