/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.SequenceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScenarioBuilder
implements Rewritable<ScenarioBuilder> {
    private final PhaseBuilder<?> phaseBuilder;
    private List<SequenceBuilder> initialSequences = new ArrayList<SequenceBuilder>();
    private List<SequenceBuilder> sequences = new ArrayList<SequenceBuilder>();
    private Collection<String> objectVars = new ArrayList<String>();
    private Collection<String> intVars = new ArrayList<String>();
    private Scenario scenario;
    private int maxRequests = 16;
    private int maxSequences = 16;

    ScenarioBuilder(PhaseBuilder<?> phaseBuilder) {
        this.phaseBuilder = phaseBuilder;
    }

    public PhaseBuilder<?> endScenario() {
        return this.phaseBuilder;
    }

    ScenarioBuilder initialSequence(SequenceBuilder sequence) {
        this.initialSequences.add(sequence);
        sequence.id(this.sequences.size());
        this.sequences.add(sequence);
        return this;
    }

    public List<SequenceBuilder> resetInitialSequences() {
        List<SequenceBuilder> prev = this.initialSequences;
        this.initialSequences = new ArrayList<SequenceBuilder>();
        return prev;
    }

    public SequenceBuilder initialSequence(String name) {
        SequenceBuilder builder = new SequenceBuilder(this, name);
        this.initialSequence(builder);
        return builder;
    }

    ScenarioBuilder sequence(SequenceBuilder sequence) {
        sequence.id(this.sequences.size());
        this.sequences.add(sequence);
        return this;
    }

    public SequenceBuilder sequence(String name) {
        SequenceBuilder builder = new SequenceBuilder(this, name);
        this.sequence(builder);
        return builder;
    }

    public boolean hasSequence(String name) {
        return this.sequences.stream().anyMatch(sb -> name.equals(sb.name()));
    }

    public SequenceBuilder findSequence(String name) {
        return this.sequences.stream().filter(sb -> name.equals(sb.name())).findFirst().orElseThrow(() -> new BenchmarkDefinitionException("No sequence " + name + " in phase " + this.endScenario().name()));
    }

    public ScenarioBuilder objectVar(String var) {
        assert (this.scenario == null);
        this.objectVars.add(var);
        return this;
    }

    public ScenarioBuilder intVar(String var) {
        assert (this.scenario == null);
        this.intVars.add(var);
        return this;
    }

    public ScenarioBuilder maxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
        return this;
    }

    public ScenarioBuilder maxSequences(int maxSequences) {
        this.maxSequences = maxSequences;
        return this;
    }

    public void prepareBuild() {
        new ArrayList<SequenceBuilder>(this.sequences).forEach(SequenceBuilder::prepareBuild);
    }

    public Scenario build() {
        if (this.scenario != null) {
            return this.scenario;
        }
        if (this.initialSequences.isEmpty()) {
            throw new BenchmarkDefinitionException("No initial sequences in phase " + this.endScenario().name());
        }
        Sequence[] initialSequences = new Sequence[this.initialSequences.size()];
        int offset = 0;
        for (int i = 0; i < this.initialSequences.size(); ++i) {
            Sequence sequence2;
            initialSequences[i] = sequence2 = this.initialSequences.get(i).build(offset);
            offset += sequence2.concurrency() > 0 ? sequence2.concurrency() : 1;
        }
        Sequence[] sequences = new Sequence[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            Sequence sequence3;
            sequences[i] = sequence3 = this.sequences.get(i).build(offset);
            offset += sequence3.concurrency() > 0 ? sequence3.concurrency() : 1;
        }
        int maxSequences = Math.max(Stream.of(sequences).mapToInt(sequence -> {
            boolean isInitial = Stream.of(initialSequences).anyMatch(s -> s == sequence);
            return isInitial ? sequence.concurrency() : sequence.concurrency() + 1;
        }).max().orElse(1), this.maxSequences);
        this.scenario = new Scenario(initialSequences, sequences, this.objectVars.toArray(new String[0]), this.intVars.toArray(new String[0]), this.maxRequests, maxSequences);
        return this.scenario;
    }

    @Override
    public void readFrom(ScenarioBuilder other) {
        this.sequences = other.sequences.stream().map(seq -> new SequenceBuilder(this, (SequenceBuilder)seq)).collect(Collectors.toList());
        this.initialSequences = other.initialSequences.stream().map(seq -> this.findMatchingSequence(seq.name())).collect(Collectors.toList());
        this.intVars = other.intVars;
        this.objectVars = other.objectVars;
    }

    private SequenceBuilder findMatchingSequence(String name) {
        return this.sequences.stream().filter(s2 -> s2.name().equals(name)).findFirst().orElseThrow(IllegalStateException::new);
    }

    Collection<SequenceBuilder> sequences() {
        return this.sequences;
    }
}

