/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Session;

public class SequenceBuilder
extends BaseSequenceBuilder {
    private final ScenarioBuilder scenario;
    private final String name;
    private int id;
    private int concurrency = 0;
    private Sequence sequence;
    private String nextSequence;

    SequenceBuilder(ScenarioBuilder scenario, String name) {
        super(null);
        this.scenario = scenario;
        int concurrencyIndex = name.indexOf(91);
        String string = this.name = concurrencyIndex < 0 ? name : name.substring(0, concurrencyIndex).trim();
        if (concurrencyIndex >= 0) {
            if (!name.endsWith("]")) {
                throw new BenchmarkDefinitionException("Malformed sequence name with concurrency: " + name);
            }
            try {
                this.concurrency = Integer.parseInt(name.substring(concurrencyIndex + 1, name.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Malformed sequence name with concurrency: " + name);
            }
        }
    }

    SequenceBuilder(ScenarioBuilder scenario, SequenceBuilder other) {
        super(null);
        this.scenario = scenario;
        this.name = other.name;
        this.concurrency = other.concurrency;
        this.readFrom(other);
        this.nextSequence = other.nextSequence;
    }

    public SequenceBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public void prepareBuild() {
        String nextSequence = this.nextSequence;
        if (nextSequence != null) {
            this.step(new NextSequenceStep(nextSequence));
        }
        super.prepareBuild();
    }

    public Sequence build(int offset) {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = new Sequence(this.name, this.id, this.concurrency, offset, this.buildSteps().toArray(new Step[0]));
        return this.sequence;
    }

    void id(int id) {
        this.id = id;
    }

    @Override
    public SequenceBuilder rootSequence() {
        return this;
    }

    @Override
    public ScenarioBuilder endSequence() {
        return this.scenario;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void nextSequence(String nextSequence) {
        this.nextSequence = nextSequence;
    }

    private static class NextSequenceStep
    implements Step {
        private final String sequence;

        public NextSequenceStep(String sequence) {
            this.sequence = sequence;
        }

        @Override
        public boolean invoke(Session s) {
            s.startSequence(this.sequence, false, Session.ConcurrencyPolicy.FAIL);
            return true;
        }
    }
}

