/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.IncludeBuilders;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@IncludeBuilders(value={@IncludeBuilders.Conversion(from=Action.Builder.class, adapter=ActionBuilderConverter.class)})
public interface StepBuilder<S extends StepBuilder<S>>
extends BuilderBase<S> {
    public List<Step> build();

    default public int id() {
        return -1;
    }

    public static class ActionStep
    implements Step,
    ResourceUtilizer {
        private final Action action;

        public ActionStep(Action action) {
            this.action = action;
        }

        @Override
        public boolean invoke(Session session) {
            this.action.run(session);
            return true;
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.action);
        }
    }

    public static class ActionAdapter
    implements StepBuilder<ActionAdapter> {
        private final Action.Builder builder;

        public ActionAdapter(Action.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void prepareBuild() {
            this.builder.prepareBuild();
        }

        @Override
        public ActionAdapter copy() {
            return new ActionAdapter((Action.Builder)this.builder.copy());
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(new ActionStep(this.builder.build()));
        }
    }

    public static class ActionBuilderConverter
    implements Function<Action.Builder, StepBuilder> {
        @Override
        public StepBuilder apply(Action.Builder builder) {
            return new ActionAdapter(builder);
        }
    }
}

