/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.api.statistics.Statistics;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class Request
implements Callable<Void>,
GenericFutureListener<Future<Void>> {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private static final TimeoutException TIMEOUT_EXCEPTION = new TimeoutException();
    private static final GenericFutureListener<Future<Object>> FAILURE_LISTENER = future -> {
        if (!future.isSuccess() && !future.isCancelled()) {
            log.error((Object)"Timeout task failed", future.cause());
        }
    };
    public final Session session;
    private long startTimestampMillis;
    private long startTimestampNanos;
    private long sendTimestampNanos;
    private SequenceInstance sequence;
    private SequenceInstance completionSequence;
    private Statistics statistics;
    private ScheduledFuture<?> timeoutFuture;
    private Connection connection;
    private Status status = Status.IDLE;
    private Result result = Result.VALID;

    public Request(Session session) {
        this.session = session;
    }

    @Override
    public Void call() {
        int uniqueId = this.session == null ? -1 : this.session.uniqueId();
        log.warn((Object)"#{} Request timeout on connection {}", new Object[]{uniqueId, this.connection});
        this.timeoutFuture = null;
        if (this.status != Status.COMPLETED) {
            this.result = Result.TIMED_OUT;
            this.statistics.incrementTimeouts(this.startTimestampMillis);
            try {
                this.handleThrowable(TIMEOUT_EXCEPTION);
            }
            catch (SessionStopException sessionStopException) {
                // empty catch block
            }
            if (this.connection == null) {
                log.warn((Object)"#{} connection is already null", new Object[]{uniqueId});
            } else {
                this.connection.onTimeout(this);
            }
        } else {
            log.trace((Object)"#{} Request {} is already completed.", new Object[]{uniqueId, this});
        }
        return null;
    }

    protected abstract void handleThrowable(Throwable var1);

    public void start(SequenceInstance sequence, Statistics statistics) {
        this.startTimestampMillis = System.currentTimeMillis();
        this.startTimestampNanos = System.nanoTime();
        this.sequence = sequence;
        this.completionSequence = sequence.incRefCnt();
        this.statistics = statistics;
        this.status = Status.RUNNING;
        this.result = Result.VALID;
    }

    public void attach(Connection connection) {
        this.connection = connection;
    }

    public Status status() {
        return this.status;
    }

    public boolean isValid() {
        return this.result == Result.VALID;
    }

    public void markInvalid() {
        this.result = Result.INVALID;
    }

    public void setCompleting() {
        this.status = Status.COMPLETING;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED || this.status == Status.IDLE;
    }

    public void setCompleted() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
        this.connection = null;
        this.sequence = null;
        if (this.status != Status.IDLE) {
            this.status = Status.COMPLETED;
            this.completionSequence.decRefCnt(this.session);
            this.completionSequence = null;
        }
    }

    public Connection connection() {
        return this.connection;
    }

    public SequenceInstance sequence() {
        return this.sequence;
    }

    public Statistics statistics() {
        return this.statistics;
    }

    public void recordResponse(long endTimestampNanos) {
        this.statistics.recordResponse(this.startTimestampMillis, this.sendTimestampNanos - this.startTimestampNanos, endTimestampNanos - this.startTimestampNanos);
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long startTimestampNanos() {
        return this.startTimestampNanos;
    }

    public long sendTimestampNanos() {
        return this.sendTimestampNanos;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutFuture = this.session.executor().schedule((Callable)this, timeout, timeUnit);
        this.timeoutFuture.addListener(FAILURE_LISTENER);
    }

    public void operationComplete(Future<Void> future) {
        try {
            this.sendTimestampNanos = System.nanoTime();
            if (!future.isSuccess()) {
                this.handleThrowable(future.cause());
            }
        }
        catch (SessionStopException sessionStopException) {
        }
        catch (Throwable t) {
            log.error((Object)"#{} Exception thrown from handleThrowable()", t, new Object[]{this.session.uniqueId()});
        }
    }

    public abstract void release();

    public void enter() {
        this.session.currentSequence(this.sequence);
        this.session.currentRequest(this);
    }

    public void exit() {
        this.session.currentSequence(null);
        this.session.currentRequest(null);
    }

    public void unsafeEnterSequence(SequenceInstance sequence) {
        this.sequence = sequence;
    }

    protected void setIdle() {
        this.status = Status.IDLE;
    }

    public static enum Status {
        IDLE,
        RUNNING,
        COMPLETING,
        COMPLETED;

    }

    public static enum Result {
        VALID,
        INVALID,
        TIMED_OUT;

    }
}

