/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.processor;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;

public interface Processor
extends Serializable {
    default public void before(Session session) {
    }

    public void process(Session var1, ByteBuf var2, int var3, int var4, boolean var5);

    default public void after(Session session) {
    }

    default public void ensureDefragmented(boolean isLastPart) {
        if (!isLastPart) {
            throw new IllegalStateException("This processor expects defragmented data.");
        }
    }

    public static class ActionAdapter
    implements Processor,
    ResourceUtilizer {
        private final Action action;

        public ActionAdapter(Action action) {
            this.action = action;
        }

        @Override
        public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
            if (!isLastPart) {
                return;
            }
            this.action.run(session);
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.action);
        }
    }

    public static abstract class BaseDelegating
    implements Processor,
    ResourceUtilizer {
        protected final Processor delegate;

        protected BaseDelegating(Processor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void before(Session session) {
            this.delegate.before(session);
        }

        @Override
        public void after(Session session) {
            this.delegate.after(session);
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.delegate);
        }
    }

    public static interface Builder<B extends Builder<B>>
    extends BuilderBase<B> {
        public Processor build(boolean var1);
    }
}

