/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.processor;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;

public interface Transformer
extends Serializable {
    default public void before(Session session) {
    }

    public void transform(Session var1, ByteBuf var2, int var3, int var4, boolean var5, ByteBuf var6);

    default public void after(Session session) {
    }

    public static abstract class BaseDelegating
    implements Transformer,
    ResourceUtilizer {
        protected final Transformer delegate;

        protected BaseDelegating(Transformer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void before(Session session) {
            this.delegate.before(session);
        }

        @Override
        public void after(Session session) {
            this.delegate.after(session);
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.delegate);
        }
    }

    public static class ProcessorAdapter
    implements Transformer,
    ResourceUtilizer {
        private final Processor delegate;

        public ProcessorAdapter(Processor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void before(Session session) {
            this.delegate.before(session);
        }

        @Override
        public void transform(Session session, ByteBuf input, int offset, int length, boolean isLastFragment, ByteBuf output) {
            this.delegate.process(session, input, offset, length, isLastFragment);
        }

        @Override
        public void after(Session session) {
            this.delegate.after(session);
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.delegate);
        }
    }

    public static interface Builder
    extends BuilderBase<Builder> {
        public Transformer build(boolean var1);
    }
}

