/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.session;

import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.SharedData;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.netty.util.concurrent.EventExecutor;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public interface Session
extends Callable<Void> {
    public void reserve(Scenario var1);

    public int uniqueId();

    public int agentThreadId();

    public int agentThreads();

    public int globalThreadId();

    public int globalThreads();

    public int agentId();

    public EventExecutor executor();

    public SharedData sharedData();

    public Phase phase();

    public long phaseStartTimestamp();

    public Statistics statistics(int var1, String var2);

    public void pruneStats(Phase var1);

    public <R extends Resource> void declareResource(ResourceKey<R> var1, Supplier<R> var2);

    public <R extends Resource> void declareResource(ResourceKey<R> var1, Supplier<R> var2, boolean var3);

    public <R extends Resource> void declareSingletonResource(ResourceKey<R> var1, R var2);

    public <R extends Resource> R getResource(ResourceKey<R> var1);

    public void currentSequence(SequenceInstance var1);

    public SequenceInstance currentSequence();

    public void attach(EventExecutor var1, SharedData var2, SessionStatistics var3);

    public void start(PhaseInstance var1);

    public void proceed();

    public void reset();

    public SequenceInstance startSequence(String var1, boolean var2, ConcurrencyPolicy var3);

    public void stop();

    public void fail(Throwable var1);

    public boolean isActive();

    public Request currentRequest();

    public void currentRequest(Request var1);

    public static enum ConcurrencyPolicy {
        FAIL,
        WARN;

    }

    public static interface ResourceKey<R extends Resource>
    extends Serializable {
    }

    public static interface Resource {
        default public void onSessionReset(Session session) {
        }
    }

    public static interface Var {
        public boolean isSet();

        public void unset();

        public VarType type();

        default public int intValue(Session session) {
            throw new UnsupportedOperationException();
        }

        default public Object objectValue(Session session) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum VarType {
        OBJECT,
        INTEGER;

    }
}

