/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.statistics.CustomValue;

public class LongValue
implements CustomValue {
    private long value;

    public void add(int increment) {
        this.value += (long)increment;
    }

    @Override
    public boolean isNull() {
        return this.value == 0L;
    }

    @Override
    public void add(CustomValue other) {
        this.value += this.val(other);
    }

    @Override
    public void substract(CustomValue other) {
        this.value -= this.val(other);
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public CustomValue clone() {
        LongValue clone = new LongValue();
        clone.value = this.value;
        return clone;
    }

    private long val(CustomValue other) {
        if (other instanceof LongValue) {
            return ((LongValue)other).value;
        }
        throw new IllegalArgumentException(String.valueOf(other));
    }

    public long value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

