/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.statistics.CustomValue;
import io.hyperfoil.api.statistics.StatisticsSummary;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.DoubleStream;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class StatisticsSnapshot
implements Serializable {
    public int sequenceId = -1;
    public final Histogram histogram = new Histogram(TimeUnit.MINUTES.toNanos(1L), 2);
    public long totalSendTime;
    public int connectFailureCount;
    public int requestCount;
    public int responseCount;
    public int status_2xx;
    public int status_3xx;
    public int status_4xx;
    public int status_5xx;
    public int status_other;
    public int invalid;
    public int cacheHits;
    public int resetCount;
    public int timeouts;
    public int internalErrors;
    public int blockedCount;
    public long blockedTime;
    public final Map<Object, CustomValue> custom = new HashMap<Object, CustomValue>();

    public int[] statuses() {
        return new int[]{this.status_2xx, this.status_3xx, this.status_4xx, this.status_5xx, this.status_other};
    }

    public boolean isEmpty() {
        return this.connectFailureCount + this.requestCount + this.responseCount + this.status_2xx + this.status_3xx + this.status_4xx + this.status_5xx + this.status_other + this.invalid + this.cacheHits + this.resetCount + this.timeouts + this.internalErrors + this.blockedCount == 0 && this.custom.values().stream().allMatch(CustomValue::isNull);
    }

    public void reset() {
        this.histogram.reset();
        this.totalSendTime = 0L;
        this.connectFailureCount = 0;
        this.requestCount = 0;
        this.responseCount = 0;
        this.status_2xx = 0;
        this.status_3xx = 0;
        this.status_4xx = 0;
        this.status_5xx = 0;
        this.status_other = 0;
        this.invalid = 0;
        this.cacheHits = 0;
        this.resetCount = 0;
        this.timeouts = 0;
        this.internalErrors = 0;
        this.blockedCount = 0;
        this.blockedTime = 0L;
        for (CustomValue value : this.custom.values()) {
            if (value == null) continue;
            value.reset();
        }
    }

    public StatisticsSnapshot clone() {
        StatisticsSnapshot copy = new StatisticsSnapshot();
        this.copyInto(copy);
        return copy;
    }

    public void copyInto(StatisticsSnapshot target) {
        this.copySequenceId(target);
        this.histogram.copyInto((AbstractHistogram)target.histogram);
        target.totalSendTime = this.totalSendTime;
        target.connectFailureCount = this.connectFailureCount;
        target.requestCount = this.requestCount;
        target.responseCount = this.responseCount;
        target.status_2xx = this.status_2xx;
        target.status_3xx = this.status_3xx;
        target.status_4xx = this.status_4xx;
        target.status_5xx = this.status_5xx;
        target.status_other = this.status_other;
        target.invalid = this.invalid;
        target.cacheHits = this.cacheHits;
        target.resetCount = this.resetCount;
        target.timeouts = this.timeouts;
        target.internalErrors = this.internalErrors;
        target.blockedCount = this.blockedCount;
        target.blockedTime = this.blockedTime;
        for (Object key : this.custom.keySet()) {
            CustomValue a = this.custom.get(key);
            key = key.toString();
            CustomValue b = target.custom.get(key);
            if (a == null) {
                if (b == null) continue;
                b.reset();
                continue;
            }
            if (b == null) {
                target.custom.put(key, a.clone());
                continue;
            }
            b.reset();
            b.add(a);
        }
    }

    public void addInto(StatisticsSnapshot target) {
        target.histogram.add((AbstractHistogram)this.histogram);
        target.totalSendTime += this.totalSendTime;
        target.connectFailureCount += this.connectFailureCount;
        target.requestCount += this.requestCount;
        target.responseCount += this.responseCount;
        target.status_2xx += this.status_2xx;
        target.status_3xx += this.status_3xx;
        target.status_4xx += this.status_4xx;
        target.status_5xx += this.status_5xx;
        target.status_other += this.status_other;
        target.invalid += this.invalid;
        target.cacheHits += this.cacheHits;
        target.resetCount += this.resetCount;
        target.timeouts += this.timeouts;
        target.internalErrors += this.internalErrors;
        target.blockedCount += this.blockedCount;
        target.blockedTime += this.blockedTime;
        for (Object key : this.custom.keySet()) {
            CustomValue a = this.custom.get(key);
            key = key.toString();
            CustomValue b = target.custom.get(key);
            if (a == null) continue;
            if (b == null) {
                target.custom.put(key, a.clone());
                continue;
            }
            b.add(a);
        }
    }

    private void copySequenceId(StatisticsSnapshot target) {
        if (this.sequenceId >= 0) {
            if (target.sequenceId >= 0 && this.sequenceId != target.sequenceId) {
                throw new IllegalArgumentException("Snapshot sequence IDs don't match");
            }
            target.sequenceId = this.sequenceId;
        }
    }

    public void subtractFrom(StatisticsSnapshot target) {
        target.histogram.subtract((AbstractHistogram)this.histogram);
        target.totalSendTime -= this.totalSendTime;
        target.connectFailureCount -= this.connectFailureCount;
        target.requestCount -= this.requestCount;
        target.responseCount -= this.responseCount;
        target.status_2xx -= this.status_2xx;
        target.status_3xx -= this.status_3xx;
        target.status_4xx -= this.status_4xx;
        target.status_5xx -= this.status_5xx;
        target.status_other -= this.status_other;
        target.invalid -= this.invalid;
        target.cacheHits -= this.cacheHits;
        target.resetCount -= this.resetCount;
        target.timeouts -= this.timeouts;
        target.internalErrors -= this.internalErrors;
        target.blockedCount -= this.blockedCount;
        target.blockedTime -= this.blockedTime;
        for (Object key : this.custom.keySet()) {
            CustomValue a = this.custom.get(key);
            key = key.toString();
            CustomValue b = target.custom.get(key);
            if (a == null) continue;
            if (b == null) {
                b = a.clone();
                b.reset();
                b.substract(a);
                target.custom.put(key, b);
                continue;
            }
            b.substract(a);
        }
    }

    public StatisticsSummary summary(double[] percentiles) {
        TreeMap percentilesMap = DoubleStream.of(percentiles).collect(TreeMap::new, (map, p) -> map.put(p * 100.0, this.histogram.getValueAtPercentile(p * 100.0)), TreeMap::putAll);
        return new StatisticsSummary(this.histogram.getStartTimeStamp(), this.histogram.getEndTimeStamp(), this.histogram.getMinValue(), (long)this.histogram.getMean(), this.histogram.getMaxValue(), this.responseCount > 0 ? this.totalSendTime / (long)this.responseCount : (long)this.resetCount, percentilesMap, this.connectFailureCount, this.requestCount, this.responseCount, this.status_2xx, this.status_3xx, this.status_4xx, this.status_5xx, this.status_other, this.invalid, this.cacheHits, this.resetCount, this.timeouts, this.internalErrors, this.blockedCount, this.blockedTime);
    }

    public long errors() {
        return this.connectFailureCount + this.resetCount + this.timeouts + this.internalErrors;
    }

    public String toString() {
        return "StatisticsSnapshot{sequenceId=" + this.sequenceId + ", start=" + this.histogram.getStartTimeStamp() + ", end=" + this.histogram.getEndTimeStamp() + ", totalSendTime=" + this.totalSendTime + ", connectFailureCount=" + this.connectFailureCount + ", requestCount=" + this.requestCount + ", responseCount=" + this.responseCount + ", status_2xx=" + this.status_2xx + ", status_3xx=" + this.status_3xx + ", status_4xx=" + this.status_4xx + ", status_5xx=" + this.status_5xx + ", status_other=" + this.status_other + ", invalid=" + this.invalid + ", cacheHits=" + this.cacheHits + ", resetCount=" + this.resetCount + ", timeouts=" + this.timeouts + ", internalErros=" + this.internalErrors + ", blockedCount=" + this.blockedCount + ", blockedTime=" + this.blockedTime + ", custom=" + this.custom + "}";
    }
}

