/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.util.SortedMap;

public class StatisticsSummary {
    public final long startTime;
    public final long endTime;
    public final long minResponseTime;
    public final long meanResponseTime;
    public final long maxResponseTime;
    public final long meanSendTime;
    public final SortedMap<Double, Long> percentileResponseTime;
    public final int connectFailureCount;
    public final int requestCount;
    public final int responseCount;
    public final int status_2xx;
    public final int status_3xx;
    public final int status_4xx;
    public final int status_5xx;
    public final int status_other;
    public final int invalid;
    public final int cacheHits;
    public final int resetCount;
    public final int timeouts;
    public final int internalErrors;
    public final int blockedCount;
    public final long blockedTime;

    @JsonCreator
    public StatisticsSummary(@JsonProperty(value="startTime") long startTime, @JsonProperty(value="endTime") long endTime, @JsonProperty(value="minResponseTime") long minResponseTime, @JsonProperty(value="meanResponseTime") long meanResponseTime, @JsonProperty(value="maxResponseTime") long maxResponseTime, @JsonProperty(value="meanSendTime") long meanSendTime, @JsonProperty(value="percentileResponseTime") SortedMap<Double, Long> percentileResponseTime, @JsonProperty(value="connectFailureCount") int connectFailureCount, @JsonProperty(value="requestCount") int requestCount, @JsonProperty(value="responseCount") int responseCount, @JsonProperty(value="status_2xx") int status_2xx, @JsonProperty(value="status_3xx") int status_3xx, @JsonProperty(value="status_4xx") int status_4xx, @JsonProperty(value="status_5xx") int status_5xx, @JsonProperty(value="status_other") int status_other, @JsonProperty(value="invalid") int invalid, @JsonProperty(value="cacheHits") int cacheHits, @JsonProperty(value="resetCount") int resetCount, @JsonProperty(value="timeouts") int timeouts, @JsonProperty(value="internalErrors") int internalErrors, @JsonProperty(value="blockedCount") int blockedCount, @JsonProperty(value="blockedTime") long blockedTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.minResponseTime = minResponseTime;
        this.meanResponseTime = meanResponseTime;
        this.maxResponseTime = maxResponseTime;
        this.meanSendTime = meanSendTime;
        this.percentileResponseTime = percentileResponseTime;
        this.connectFailureCount = connectFailureCount;
        this.requestCount = requestCount;
        this.responseCount = responseCount;
        this.status_2xx = status_2xx;
        this.status_3xx = status_3xx;
        this.status_4xx = status_4xx;
        this.status_5xx = status_5xx;
        this.status_other = status_other;
        this.invalid = invalid;
        this.cacheHits = cacheHits;
        this.resetCount = resetCount;
        this.timeouts = timeouts;
        this.internalErrors = internalErrors;
        this.blockedCount = blockedCount;
        this.blockedTime = blockedTime;
    }

    public static void printHeader(PrintWriter writer, double[] percentiles) {
        writer.print("Requests,Responses,Mean,Min,");
        for (double p : percentiles) {
            writer.print('p');
            writer.print(p * 100.0);
            writer.print(',');
        }
        writer.print("Max,MeanSendTime,ConnFailure,Reset,Timeouts,2xx,3xx,4xx,5xx,Other,Invalid,CacheHits,BlockedCount,BlockedTime,InternalErrors");
    }

    public void printTo(PrintWriter writer) {
        writer.print(this.requestCount);
        writer.print(',');
        writer.print(this.responseCount);
        writer.print(',');
        writer.print(this.meanResponseTime);
        writer.print(',');
        writer.print(this.minResponseTime);
        writer.print(',');
        for (long prt : this.percentileResponseTime.values()) {
            writer.print(prt);
            writer.print(',');
        }
        writer.print(this.maxResponseTime);
        writer.print(',');
        writer.print(this.meanSendTime);
        writer.print(',');
        writer.print(this.connectFailureCount);
        writer.print(',');
        writer.print(this.resetCount);
        writer.print(',');
        writer.print(this.timeouts);
        writer.print(',');
        writer.print(this.status_2xx);
        writer.print(',');
        writer.print(this.status_3xx);
        writer.print(',');
        writer.print(this.status_4xx);
        writer.print(',');
        writer.print(this.status_5xx);
        writer.print(',');
        writer.print(this.status_other);
        writer.print(',');
        writer.print(this.invalid);
        writer.print(',');
        writer.print(this.cacheHits);
        writer.print(',');
        writer.print(this.blockedCount);
        writer.print(',');
        writer.print(this.blockedTime);
        writer.print(',');
        writer.print(this.internalErrors);
    }
}

