/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.channel.exit.ExitSignalChannelRequestHandler;
import org.apache.sshd.client.channel.exit.ExitStatusChannelRequestHandler;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.EventNotifier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractClientChannel
extends AbstractChannel
implements ClientChannel {
    protected final AtomicBoolean opened = new AtomicBoolean();
    protected ClientChannel.Streaming streaming;
    protected ChannelAsyncOutputStream asyncIn;
    protected ChannelAsyncInputStream asyncOut;
    protected ChannelAsyncInputStream asyncErr;
    protected InputStream in;
    protected OutputStream invertedIn;
    protected OutputStream out;
    protected InputStream invertedOut;
    protected OutputStream err;
    protected InputStream invertedErr;
    protected final AtomicReference<Integer> exitStatusHolder = new AtomicReference<Object>(null);
    protected final AtomicReference<String> exitSignalHolder = new AtomicReference<Object>(null);
    protected int openFailureReason;
    protected String openFailureMsg;
    protected String openFailureLang;
    protected OpenFuture openFuture;
    private final String channelType;

    protected AbstractClientChannel(String type) {
        this(type, Collections.emptyList());
    }

    protected AbstractClientChannel(String type, Collection<? extends RequestHandler<Channel>> handlers) {
        super(true, handlers);
        this.channelType = ValidateUtils.checkNotNullAndNotEmpty((String)type, (String)"No channel type specified");
        this.streaming = ClientChannel.Streaming.Sync;
        this.addChannelSignalRequestHandlers((EventNotifier<String>)((EventNotifier)event -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyEvent({}): {}", (Object)this, event);
            }
            this.notifyStateChanged((String)event);
        }));
    }

    @Override
    public ClientSession getClientSession() {
        return (ClientSession)super.getSession();
    }

    protected void addChannelSignalRequestHandlers(EventNotifier<String> notifier) {
        this.addRequestHandler(new ExitStatusChannelRequestHandler(this.exitStatusHolder, (EventNotifier<? super String>)notifier));
        this.addRequestHandler(new ExitSignalChannelRequestHandler(this.exitSignalHolder, (EventNotifier<? super String>)notifier));
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public ClientChannel.Streaming getStreaming() {
        return this.streaming;
    }

    @Override
    public void setStreaming(ClientChannel.Streaming streaming) {
        this.streaming = streaming;
    }

    @Override
    public IoOutputStream getAsyncIn() {
        return this.asyncIn;
    }

    @Override
    public IoInputStream getAsyncOut() {
        return this.asyncOut;
    }

    @Override
    public IoInputStream getAsyncErr() {
        return this.asyncErr;
    }

    @Override
    public OutputStream getInvertedIn() {
        return this.invertedIn;
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void setIn(InputStream in) {
        this.in = in;
    }

    @Override
    public InputStream getInvertedOut() {
        return this.invertedOut;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream out) {
        this.out = out;
    }

    @Override
    public InputStream getInvertedErr() {
        return this.invertedErr;
    }

    public OutputStream getErr() {
        return this.err;
    }

    @Override
    public void setErr(OutputStream err) {
        this.err = err;
    }

    @Override
    protected org.apache.sshd.common.Closeable getInnerCloseable() {
        return this.builder().when((SshFuture)this.openFuture).run((Object)this.toString(), () -> {
            if (this.openFuture == null) {
                this.gracefulFuture.setClosed();
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.in, this.out, this.err});
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.invertedIn, this.invertedOut, this.invertedErr});
        }).parallel(new org.apache.sshd.common.Closeable[]{this.asyncIn, this.asyncOut, this.asyncErr}).close(super.getInnerCloseable()).build();
    }

    @Override
    public Set<ClientChannelEvent> waitFor(Collection<ClientChannelEvent> mask, long timeout) {
        Objects.requireNonNull(mask, "No mask specified");
        long t = 0L;
        boolean debugEnabled = this.log.isDebugEnabled();
        boolean traceEnabled = this.log.isTraceEnabled();
        Object object = this.lock;
        synchronized (object) {
            EnumSet<ClientChannelEvent> cond = EnumSet.noneOf(ClientChannelEvent.class);
            while (true) {
                block20: {
                    boolean nothingInCommon;
                    this.updateCurrentChannelState(cond);
                    if (debugEnabled) {
                        if (cond.contains((Object)ClientChannelEvent.EXIT_STATUS)) {
                            this.log.debug("waitFor({}) mask={} - exit status={}", new Object[]{this, mask, this.exitStatusHolder});
                        }
                        if (cond.contains((Object)ClientChannelEvent.EXIT_SIGNAL)) {
                            this.log.debug("waitFor({}) mask={} - exit signal={}", new Object[]{this, mask, this.exitSignalHolder});
                        }
                    }
                    if (!(nothingInCommon = Collections.disjoint(mask, cond))) {
                        if (traceEnabled) {
                            this.log.trace("WaitFor call returning on channel {}, mask={}, cond={}", new Object[]{this, mask, cond});
                        }
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                if (traceEnabled) {
                                    this.log.trace("WaitFor call timeout on channel {}, mask={}", (Object)this, mask);
                                }
                                cond.add(ClientChannelEvent.TIMEOUT);
                                return cond;
                            }
                        }
                    }
                    if (traceEnabled) {
                        this.log.trace("Waiting {} millis for lock on channel {}, mask={}, cond={}", new Object[]{timeout, this, mask, cond});
                    }
                    long nanoStart = System.nanoTime();
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                        } else {
                            this.lock.wait();
                        }
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (traceEnabled) {
                            this.log.trace("Lock notified on channel {} after {} nanos", (Object)this, (Object)nanoDuration);
                        }
                    }
                    catch (InterruptedException e) {
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (!traceEnabled) break block20;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", new Object[]{this, mask, nanoDuration});
                    }
                }
                cond.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ClientChannelEvent> getChannelState() {
        EnumSet<ClientChannelEvent> cond = EnumSet.noneOf(ClientChannelEvent.class);
        Object object = this.lock;
        synchronized (object) {
            return this.updateCurrentChannelState(cond);
        }
    }

    protected <C extends Collection<ClientChannelEvent>> C updateCurrentChannelState(C state) {
        if (this.openFuture != null && this.openFuture.isOpened()) {
            state.add((ClientChannelEvent)ClientChannelEvent.OPENED);
        }
        if (this.closeFuture.isClosed()) {
            state.add((ClientChannelEvent)ClientChannelEvent.CLOSED);
        }
        if (this.isEofSignalled()) {
            state.add((ClientChannelEvent)ClientChannelEvent.EOF);
        }
        if (this.exitStatusHolder.get() != null) {
            state.add((ClientChannelEvent)ClientChannelEvent.EXIT_STATUS);
        }
        if (this.exitSignalHolder.get() != null) {
            state.add((ClientChannelEvent)ClientChannelEvent.EXIT_SIGNAL);
        }
        return state;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        if (this.isClosing()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.toString(), this.lock);
        String type = this.getChannelType();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) Send SSH_MSG_CHANNEL_OPEN - type={}", (Object)this, (Object)type);
        }
        Session session = this.getSession();
        Window wLocal = this.getLocalWindow();
        Buffer buffer = session.createBuffer((byte)90, type.length() + 32);
        buffer.putString(type);
        buffer.putInt((long)this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    public OpenFuture open(int recipient, long rwSize, long packetSize, Buffer buffer) {
        throw new UnsupportedOperationException("open(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOpenSuccess(int recipient, long rwSize, long packetSize, Buffer buffer) {
        this.setRecipient(recipient);
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        Window wRemote = this.getRemoteWindow();
        wRemote.init(rwSize, packetSize, manager);
        String changeEvent = "SSH_MSG_CHANNEL_OPEN_CONFIRMATION";
        try {
            this.doOpen();
            this.signalChannelOpenSuccess();
            this.opened.set(true);
            this.openFuture.setOpened();
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException((Throwable)t);
            changeEvent = e.getClass().getName();
            this.signalChannelOpenFailure(e);
            this.openFuture.setException(e);
            this.closeFuture.setClosed();
            this.doCloseImmediately();
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected abstract void doOpen() throws IOException;

    @Override
    public void handleOpenFailure(Buffer buffer) {
        int reason = buffer.getInt();
        String msg = buffer.getString();
        String lang = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleOpenFailure({}) reason={}, lang={}, msg={}", new Object[]{this, SshConstants.getOpenErrorCodeName((int)reason), lang, msg});
        }
        this.openFailureReason = reason;
        this.openFailureMsg = msg;
        this.openFailureLang = lang;
        this.openFuture.setException(new SshChannelOpenException(this.getId(), reason, msg));
        this.closeFuture.setClosed();
        this.doCloseImmediately();
        this.notifyStateChanged("SSH_MSG_CHANNEL_OPEN_FAILURE");
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        if (this.asyncOut != null) {
            this.asyncOut.write((Readable)new ByteArrayBuffer(data, off, (int)len));
        } else if (this.out != null) {
            this.out.write(data, off, (int)len);
            this.out.flush();
            if (this.invertedOut == null) {
                Window wLocal = this.getLocalWindow();
                wLocal.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No output stream for channel");
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Extended data length exceeds int boundaries: %d", (long)len);
        if (this.asyncErr != null) {
            this.asyncErr.write((Readable)new ByteArrayBuffer(data, off, (int)len));
        } else if (this.err != null) {
            this.err.write(data, off, (int)len);
            this.err.flush();
            if (this.invertedErr == null) {
                Window wLocal = this.getLocalWindow();
                wLocal.consumeAndCheck(len);
            }
        } else {
            throw new IllegalStateException("No error stream for channel");
        }
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncIn != null) {
            this.asyncIn.onWindowExpanded();
        }
    }

    @Override
    public Integer getExitStatus() {
        return this.exitStatusHolder.get();
    }

    @Override
    public String getExitSignal() {
        return this.exitSignalHolder.get();
    }
}

