/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.controller.model.CustomStats;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.Run;
import io.hyperfoil.controller.model.Version;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Client {
    public BenchmarkRef register(Benchmark var1, String var2);

    public BenchmarkRef register(String var1, Map<String, Path> var2, String var3, String var4);

    public List<String> benchmarks();

    public BenchmarkRef benchmark(String var1);

    public List<Run> runs(boolean var1);

    public RunRef run(String var1);

    public long ping();

    public Version version();

    public Collection<String> agents();

    public String downloadLog(String var1, String var2, long var3, File var5);

    public void shutdown(boolean var1);

    public static class EditConflictException
    extends RuntimeException {
    }

    public static class MinMax {
        public final int min;
        public final int max;

        @JsonCreator
        public MinMax(@JsonProperty(value="min") int min, @JsonProperty(value="max") int max) {
            this.min = min;
            this.max = max;
        }
    }

    public static interface RunRef {
        public String id();

        public Run get();

        public RunRef kill();

        public Benchmark benchmark();

        public Map<String, Map<String, MinMax>> sessionStatsRecent();

        public Map<String, Map<String, MinMax>> sessionStatsTotal();

        public Collection<String> sessions();

        public Collection<String> connections();

        public RequestStatisticsResponse statsRecent();

        public RequestStatisticsResponse statsTotal();

        public byte[] statsAll(String var1);

        public Histogram histogram(String var1, int var2, String var3);

        public Collection<CustomStats> customStats();

        public byte[] file(String var1);
    }

    public static class BenchmarkSource {
        public final String source;
        public final String version;

        public BenchmarkSource(String source, String version) {
            this.source = source;
            this.version = version;
        }
    }

    public static interface BenchmarkRef {
        public String name();

        public BenchmarkSource source();

        public Benchmark get();

        public RunRef start(String var1);

        public String structure();
    }
}

