/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.controller.model.Histogram;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.HistogramLogReader;
import org.HdrHistogram.HistogramLogWriter;

public final class HistogramConverter {
    private HistogramConverter() {
    }

    public static Histogram convert(String phase, String metric, AbstractHistogram source) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.getNeededByteBufferCapacity() + 100);
        HistogramLogWriter writer = new HistogramLogWriter((OutputStream)bos);
        writer.outputIntervalHistogram((EncodableHistogram)source);
        writer.close();
        return new Histogram(phase, metric, source.getStartTimeStamp(), source.getEndTimeStamp(), new String(bos.toByteArray(), StandardCharsets.UTF_8));
    }

    public static AbstractHistogram convert(Histogram source) {
        ByteArrayInputStream bis = new ByteArrayInputStream(source.data.getBytes(StandardCharsets.UTF_8));
        EncodableHistogram histogram = new HistogramLogReader((InputStream)bis).nextIntervalHistogram();
        if (histogram == null) {
            return null;
        }
        histogram.setStartTimeStamp(source.startTime);
        histogram.setEndTimeStamp(source.endTime);
        return (AbstractHistogram)histogram;
    }
}

