/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller.router;

import io.hyperfoil.controller.ApiService;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;

public class ApiRouter {
    private final ApiService service;
    private static final Logger log = LoggerFactory.getLogger(ApiRouter.class);

    public ApiRouter(ApiService service, Router router) {
        this.service = service;
        router.route().handler((Handler)BodyHandler.create((String)System.getProperty("java.io.tmpdir")));
        router.errorHandler(500, ctx -> log.error((Object)"Error processing {} {}", new Object[]{ctx.request().method(), ctx.request().uri(), ctx.failure()}));
        router.get("/openapi").produces("text/vnd.yaml").handler(this::openApi);
        router.get("/benchmark").produces("application/json").handler(this::listBenchmarks);
        router.post("/benchmark").consumes("application/json").handler(this::addBenchmark$application_json);
        router.post("/benchmark").consumes("text/vnd.yaml").handler(this::addBenchmark$text_vnd_yaml);
        router.post("/benchmark").consumes("application/java-serialized-object").handler(this::addBenchmark$application_java_serialized_object);
        router.post("/benchmark").consumes("multipart/form-data").handler(this::addBenchmark$multipart_form_data);
        router.get("/benchmark/:name").produces("text/vnd.yaml").handler(this::getBenchmark$text_vnd_yaml);
        router.get("/benchmark/:name").produces("application/java-serialized-object").handler(this::getBenchmark$application_java_serialized_object);
        router.get("/benchmark/:name/start").produces("application/json").handler(this::startBenchmark);
        router.get("/benchmark/:name/structure").produces("text/vnd.yaml").handler(this::getBenchmarkStructure);
        router.get("/run").produces("application/json").handler(this::listRuns);
        router.get("/run/:runId").produces("application/json").handler(this::getRun);
        router.get("/run/:runId/kill").handler(this::killRun);
        router.get("/run/:runId/sessions").produces("text/plain").handler(this::listSessions);
        router.get("/run/:runId/sessions/recent").produces("application/json").handler(this::getRecentSessions);
        router.get("/run/:runId/sessions/total").produces("application/json").handler(this::getTotalSessions);
        router.get("/run/:runId/connections").produces("text/plain").handler(this::listConnections);
        router.get("/run/:runId/stats/all").produces("application/zip").handler(this::getAllStats$application_zip);
        router.get("/run/:runId/stats/all").produces("application/json").handler(this::getAllStats$application_json);
        router.get("/run/:runId/stats/all/json").produces("application/json").handler(this::getAllStatsJson);
        router.get("/run/:runId/stats/all/csv").produces("application/zip").handler(this::getAllStatsCsv);
        router.get("/run/:runId/stats/recent").produces("application/json").handler(this::getRecentStats);
        router.get("/run/:runId/stats/total").produces("application/json").handler(this::getTotalStats);
        router.get("/run/:runId/stats/custom").produces("application/json").handler(this::getCustomStats);
        router.get("/run/:runId/stats/histogram").produces("application/json").handler(this::getHistogramStats);
        router.get("/run/:runId/file").produces("application/octet-stream").handler(this::getRunFile);
        router.get("/run/:runId/benchmark").produces("text/vnd.yaml").handler(this::getBenchmarkForRun$text_vnd_yaml);
        router.get("/run/:runId/benchmark").produces("application/java-serialized-object").handler(this::getBenchmarkForRun$application_java_serialized_object);
        router.get("/agents").produces("application/json").handler(this::listAgents);
        router.get("/log").produces("text/plain").handler(this::getControllerLog);
        router.get("/log/:agent").produces("text/plain").handler(this::getAgentLog);
        router.get("/shutdown").handler(this::shutdown);
        router.get("/token").handler(this::getToken);
        router.get("/version").produces("application/json").handler(this::getVersion);
    }

    private void openApi(RoutingContext ctx) {
        this.service.openApi(ctx);
    }

    private void listBenchmarks(RoutingContext ctx) {
        this.service.listBenchmarks(ctx);
    }

    private void addBenchmark$application_json(RoutingContext ctx) {
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        String _storedFilesBenchmark = this.queryParam(ctx, "storedFilesBenchmark", null);
        String storedFilesBenchmark = this.convert(_storedFilesBenchmark, String.class);
        this.service.addBenchmark$application_json(ctx, ifMatch, storedFilesBenchmark);
    }

    private void addBenchmark$text_vnd_yaml(RoutingContext ctx) {
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        String _storedFilesBenchmark = this.queryParam(ctx, "storedFilesBenchmark", null);
        String storedFilesBenchmark = this.convert(_storedFilesBenchmark, String.class);
        this.service.addBenchmark$text_vnd_yaml(ctx, ifMatch, storedFilesBenchmark);
    }

    private void addBenchmark$application_java_serialized_object(RoutingContext ctx) {
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        String _storedFilesBenchmark = this.queryParam(ctx, "storedFilesBenchmark", null);
        String storedFilesBenchmark = this.convert(_storedFilesBenchmark, String.class);
        this.service.addBenchmark$application_java_serialized_object(ctx, ifMatch, storedFilesBenchmark);
    }

    private void addBenchmark$multipart_form_data(RoutingContext ctx) {
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        String _storedFilesBenchmark = this.queryParam(ctx, "storedFilesBenchmark", null);
        String storedFilesBenchmark = this.convert(_storedFilesBenchmark, String.class);
        this.service.addBenchmark$multipart_form_data(ctx, ifMatch, storedFilesBenchmark);
    }

    private void getBenchmark$text_vnd_yaml(RoutingContext ctx) {
        String _name = this.pathParam(ctx, "name", null);
        if (_name == null) {
            ctx.response().setStatusCode(400).end("path parameter 'name' was not set!");
            return;
        }
        String name = this.convert(_name, String.class);
        this.service.getBenchmark$text_vnd_yaml(ctx, name);
    }

    private void getBenchmark$application_java_serialized_object(RoutingContext ctx) {
        String _name = this.pathParam(ctx, "name", null);
        if (_name == null) {
            ctx.response().setStatusCode(400).end("path parameter 'name' was not set!");
            return;
        }
        String name = this.convert(_name, String.class);
        this.service.getBenchmark$application_java_serialized_object(ctx, name);
    }

    private void startBenchmark(RoutingContext ctx) {
        String _name = this.pathParam(ctx, "name", null);
        if (_name == null) {
            ctx.response().setStatusCode(400).end("path parameter 'name' was not set!");
            return;
        }
        String name = this.convert(_name, String.class);
        String _desc = this.queryParam(ctx, "desc", null);
        String desc = this.convert(_desc, String.class);
        String _xTriggerJob = this.headerParam(ctx, "x-trigger-job", null);
        String xTriggerJob = this.convert(_xTriggerJob, String.class);
        String _runId = this.queryParam(ctx, "runId", null);
        String runId = this.convert(_runId, String.class);
        this.service.startBenchmark(ctx, name, desc, xTriggerJob, runId);
    }

    private void getBenchmarkStructure(RoutingContext ctx) {
        String _name = this.pathParam(ctx, "name", null);
        if (_name == null) {
            ctx.response().setStatusCode(400).end("path parameter 'name' was not set!");
            return;
        }
        String name = this.convert(_name, String.class);
        this.service.getBenchmarkStructure(ctx, name);
    }

    private void listRuns(RoutingContext ctx) {
        String _details = this.queryParam(ctx, "details", "false");
        boolean details = this.convert(_details, Boolean.TYPE);
        this.service.listRuns(ctx, details);
    }

    private void getRun(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getRun(ctx, runId);
    }

    private void killRun(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.killRun(ctx, runId);
    }

    private void listSessions(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        String _inactive = this.queryParam(ctx, "inactive", "false");
        boolean inactive = this.convert(_inactive, Boolean.TYPE);
        this.service.listSessions(ctx, runId, inactive);
    }

    private void getRecentSessions(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getRecentSessions(ctx, runId);
    }

    private void getTotalSessions(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getTotalSessions(ctx, runId);
    }

    private void listConnections(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.listConnections(ctx, runId);
    }

    private void getAllStats$application_zip(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getAllStats$application_zip(ctx, runId);
    }

    private void getAllStats$application_json(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getAllStats$application_json(ctx, runId);
    }

    private void getAllStatsJson(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getAllStatsJson(ctx, runId);
    }

    private void getAllStatsCsv(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getAllStatsCsv(ctx, runId);
    }

    private void getRecentStats(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getRecentStats(ctx, runId);
    }

    private void getTotalStats(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getTotalStats(ctx, runId);
    }

    private void getCustomStats(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getCustomStats(ctx, runId);
    }

    private void getHistogramStats(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        String _phase = this.queryParam(ctx, "phase", null);
        if (_phase == null) {
            ctx.response().setStatusCode(400).end("query parameter 'phase' was not set!");
            return;
        }
        String phase = this.convert(_phase, String.class);
        String _stepId = this.queryParam(ctx, "stepId", null);
        if (_stepId == null) {
            ctx.response().setStatusCode(400).end("query parameter 'stepId' was not set!");
            return;
        }
        int stepId = this.convert(_stepId, Integer.TYPE);
        String _metric = this.queryParam(ctx, "metric", null);
        if (_metric == null) {
            ctx.response().setStatusCode(400).end("query parameter 'metric' was not set!");
            return;
        }
        String metric = this.convert(_metric, String.class);
        this.service.getHistogramStats(ctx, runId, phase, stepId, metric);
    }

    private void getRunFile(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        String _file = this.queryParam(ctx, "file", null);
        if (_file == null) {
            ctx.response().setStatusCode(400).end("query parameter 'file' was not set!");
            return;
        }
        String file = this.convert(_file, String.class);
        this.service.getRunFile(ctx, runId, file);
    }

    private void getBenchmarkForRun$text_vnd_yaml(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getBenchmarkForRun$text_vnd_yaml(ctx, runId);
    }

    private void getBenchmarkForRun$application_java_serialized_object(RoutingContext ctx) {
        String _runId = this.pathParam(ctx, "runId", null);
        if (_runId == null) {
            ctx.response().setStatusCode(400).end("path parameter 'runId' was not set!");
            return;
        }
        String runId = this.convert(_runId, String.class);
        this.service.getBenchmarkForRun$application_java_serialized_object(ctx, runId);
    }

    private void listAgents(RoutingContext ctx) {
        this.service.listAgents(ctx);
    }

    private void getControllerLog(RoutingContext ctx) {
        String _offset = this.queryParam(ctx, "offset", "0");
        long offset = this.convert(_offset, Long.TYPE);
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        this.service.getControllerLog(ctx, offset, ifMatch);
    }

    private void getAgentLog(RoutingContext ctx) {
        String _agent = this.pathParam(ctx, "agent", null);
        if (_agent == null) {
            ctx.response().setStatusCode(400).end("path parameter 'agent' was not set!");
            return;
        }
        String agent = this.convert(_agent, String.class);
        String _offset = this.queryParam(ctx, "offset", "0");
        long offset = this.convert(_offset, Long.TYPE);
        String _ifMatch = this.headerParam(ctx, "if-match", null);
        String ifMatch = this.convert(_ifMatch, String.class);
        this.service.getAgentLog(ctx, agent, offset, ifMatch);
    }

    private void shutdown(RoutingContext ctx) {
        String _force = this.queryParam(ctx, "force", "false");
        boolean force = this.convert(_force, Boolean.TYPE);
        this.service.shutdown(ctx, force);
    }

    private void getToken(RoutingContext ctx) {
        this.service.getToken(ctx);
    }

    private void getVersion(RoutingContext ctx) {
        this.service.getVersion(ctx);
    }

    private String pathParam(RoutingContext ctx, String name, String defaultValue) {
        return ctx.pathParam(name);
    }

    private String queryParam(RoutingContext ctx, String name, String defaultValue) {
        List list = ctx.queryParam(name);
        if (list == null || list.isEmpty()) {
            return defaultValue;
        }
        return (String)list.iterator().next();
    }

    private String headerParam(RoutingContext ctx, String name, String defaultValue) {
        String value = ctx.request().getHeader(name);
        return value == null ? defaultValue : value;
    }

    <T> T convert(String value, Class<T> type) {
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        return (T)Json.decodeValue((String)value, type);
    }
}

