/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.metadata.Metadata;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.util.function.SerializablePredicate;

public class InfinispanAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V> {
    private final VertxInternal vertx;
    private final EmbeddedMultimapCache<Object, Object> multimapCache;
    private final ConcurrentMap<K, ChoosableSet<V>> nearCache;
    private final TaskQueue taskQueue;

    public InfinispanAsyncMultiMap(Vertx vertx, EmbeddedMultimapCache<Object, Object> multimapCache) {
        this.vertx = (VertxInternal)vertx;
        this.multimapCache = multimapCache;
        this.nearCache = new ConcurrentHashMap<K, ChoosableSet<V>>();
        Set filterAnnotations = Stream.builder().add(CacheEntryCreated.class).add(CacheEntryModified.class).add(CacheEntryRemoved.class).build().collect(Collectors.toSet());
        multimapCache.getCache().addFilteredListener((Object)new EntryListener(), (CacheEventFilter)new EventFilter(), (CacheEventConverter)new EventConverter(), filterAnnotations);
        this.taskQueue = new TaskQueue();
    }

    private <T> void cfGet(CompletableFuture<T> cf, Promise<T> future) {
        try {
            future.complete(cf.get());
        }
        catch (ExecutionException e) {
            future.fail(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.fail((Throwable)e);
        }
    }

    public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        this.vertx.getOrCreateContext().executeBlocking(fut -> this.cfGet(this.multimapCache.put(kk, vv), (Promise)fut), this.taskQueue, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> resultHandler) {
        Queue getRequests;
        ContextInternal context = this.vertx.getOrCreateContext();
        Queue queue = getRequests = (Queue)context.contextData().computeIfAbsent(this, ctx -> new ArrayDeque());
        synchronized (queue) {
            ChoosableSet entries = (ChoosableSet)this.nearCache.get(k);
            if (entries != null && entries.isInitialised() && getRequests.isEmpty()) {
                context.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)entries)));
            } else {
                getRequests.add(new GetRequest<K, V>(k, resultHandler));
                if (getRequests.size() == 1) {
                    this.dequeueGet(context, getRequests);
                }
            }
        }
    }

    private void dequeueGet(ContextInternal context, Queue<GetRequest<K, V>> getRequests) {
        Handler handler;
        GetRequest<K, V> getRequest;
        block1: {
            do {
                getRequest = getRequests.peek();
                ChoosableSet entries = (ChoosableSet)this.nearCache.get(getRequest.key);
                if (entries == null || !entries.isInitialised()) break block1;
                handler = getRequest.handler;
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)entries)));
                getRequests.remove();
            } while (!getRequests.isEmpty());
            return;
        }
        Object key = getRequest.key;
        handler = getRequest.handler;
        context.executeBlocking(fut -> {
            ChoosableSet prev;
            ChoosableSet sids;
            Collection collect;
            try {
                collect = (Collection)this.multimapCache.get(DataConverter.toCachedObject(key)).get();
            }
            catch (ExecutionException e) {
                fut.fail(e.getCause());
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                fut.fail((Throwable)e);
                return;
            }
            Collection entries = collect.stream().map(DataConverter::fromCachedObject).collect(Collectors.toList());
            if (entries != null) {
                sids = new ChoosableSet(entries.size());
                for (Object hid : entries) {
                    sids.add(hid);
                }
            } else {
                sids = new ChoosableSet(0);
            }
            ChoosableSet choosableSet = prev = sids.isEmpty() ? null : this.nearCache.putIfAbsent(key, sids);
            if (prev != null) {
                prev.merge(sids);
                sids = prev;
            }
            sids.setInitialised();
            fut.complete(sids);
        }, this.taskQueue, res -> {
            Queue queue = getRequests;
            synchronized (queue) {
                context.runOnContext(v -> handler.handle(res));
                getRequests.remove();
                if (!getRequests.isEmpty()) {
                    this.dequeueGet(context, getRequests);
                }
            }
        });
    }

    public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        this.vertx.getOrCreateContext().executeBlocking(fut -> this.cfGet(this.multimapCache.remove(kk, vv), (Promise)fut), this.taskQueue, completionHandler);
    }

    public void removeAllForValue(V v, Handler<AsyncResult<Void>> completionHandler) {
        this.removeAllMatching(v::equals, completionHandler);
    }

    public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(fut -> this.cfGet(this.multimapCache.remove((SerializablePredicate & Serializable)o -> p.test(DataConverter.fromCachedObject(o))), (Promise)fut), this.taskQueue, completionHandler);
    }

    public void clearCache() {
        this.nearCache.clear();
    }

    public static class ModifiedCollectionExternalizer
    implements Externalizer<ModifiedCollection> {
        public void writeObject(ObjectOutput objectOutput, ModifiedCollection modifiedCollection) throws IOException {
            objectOutput.writeObject(modifiedCollection.toDelete);
            objectOutput.writeObject(modifiedCollection.toAdd);
        }

        public ModifiedCollection readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            return new ModifiedCollection((Collection)objectInput.readObject(), (Collection)objectInput.readObject());
        }
    }

    @SerializeWith(value=ModifiedCollectionExternalizer.class)
    private static class ModifiedCollection {
        final Collection<Object> toDelete;
        final Collection<Object> toAdd;

        private ModifiedCollection(Collection<Object> toDelete, Collection<Object> toAdd) {
            this.toDelete = toDelete;
            this.toAdd = toAdd;
        }
    }

    public static class EventConverterExternalizer
    implements Externalizer<EventConverter> {
        public void writeObject(ObjectOutput objectOutput, EventConverter eventConverter) {
        }

        public EventConverter readObject(ObjectInput objectInput) {
            return new EventConverter();
        }
    }

    @SerializeWith(value=EventConverterExternalizer.class)
    private static class EventConverter
    implements CacheEventConverter<Object, Collection<Object>, Object> {
        private EventConverter() {
        }

        public Object convert(Object key, Collection<Object> oldValue, Metadata oldMetadata, Collection<Object> newValue, Metadata newMetadata, EventType eventType) {
            if (eventType.getType() == Event.Type.CACHE_ENTRY_MODIFIED) {
                if (oldValue != null && newValue != null) {
                    oldValue.removeAll(newValue);
                    newValue.removeAll(oldValue);
                }
                return new ModifiedCollection(oldValue, newValue);
            }
            return newValue;
        }
    }

    public static class EventFilterExternalizer
    implements Externalizer<EventFilter> {
        public void writeObject(ObjectOutput objectOutput, EventFilter eventFilter) {
        }

        public EventFilter readObject(ObjectInput objectInput) {
            return new EventFilter();
        }
    }

    @SerializeWith(value=EventFilterExternalizer.class)
    private static class EventFilter
    implements CacheEventFilter<Object, Collection<Object>> {
        private EventFilter() {
        }

        public boolean accept(Object key, Collection<Object> oldValue, Metadata oldMetadata, Collection<Object> newValue, Metadata newMetadata, EventType eventType) {
            return true;
        }
    }

    private static class GetRequest<K, V> {
        final K key;
        final Handler<AsyncResult<ChoosableIterable<V>>> handler;

        GetRequest(K key, Handler<AsyncResult<ChoosableIterable<V>>> handler) {
            this.key = key;
            this.handler = handler;
        }
    }

    private static class ChoosableSet<T>
    implements ChoosableIterable<T> {
        private volatile boolean initialised;
        private final Set<T> ids;
        private volatile Iterator<T> iter;

        public ChoosableSet(int initialSize) {
            this.ids = new ConcurrentHashSet(initialSize);
        }

        public boolean isInitialised() {
            return this.initialised;
        }

        public void setInitialised() {
            this.initialised = true;
        }

        public void add(T elem) {
            this.ids.add(elem);
        }

        public void remove(T elem) {
            this.ids.remove(elem);
        }

        public void merge(ChoosableSet<T> toMerge) {
            this.ids.addAll(toMerge.ids);
        }

        public boolean isEmpty() {
            return this.ids.isEmpty();
        }

        public Iterator<T> iterator() {
            return this.ids.iterator();
        }

        public synchronized T choose() {
            if (!this.ids.isEmpty()) {
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = this.ids.iterator();
                }
                try {
                    return this.iter.next();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
            }
            return null;
        }
    }

    @Listener(clustered=true, observation=Listener.Observation.POST)
    private class EntryListener {
        private EntryListener() {
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryCreatedEvent<Object, Object> event) {
            Object k = DataConverter.fromCachedObject(event.getKey());
            Collection values = (Collection)event.getValue();
            ChoosableSet entries = InfinispanAsyncMultiMap.this.nearCache.compute(k, (key, choosableSet) -> choosableSet == null ? new ChoosableSet(values.size()) : choosableSet);
            for (Object value : values) {
                entries.add(DataConverter.fromCachedObject(value));
            }
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent<Object, Object> event) {
            Object k = DataConverter.fromCachedObject(event.getKey());
            ModifiedCollection modifiedCollection = (ModifiedCollection)event.getValue();
            ChoosableSet entries = (ChoosableSet)InfinispanAsyncMultiMap.this.nearCache.get(k);
            if (entries != null) {
                this.forEachModified(modifiedCollection.toAdd, entries::add);
                this.forEachModified(modifiedCollection.toDelete, entries::remove);
            }
        }

        private void forEachModified(Collection<Object> collection, Consumer<V> action) {
            if (collection != null) {
                collection.stream().map(DataConverter::fromCachedObject).forEach(action);
            }
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent<Object, Object> event) {
            Object k = DataConverter.fromCachedObject(event.getKey());
            InfinispanAsyncMultiMap.this.nearCache.remove(k);
        }
    }
}

