/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.k8s;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.hyperfoil.api.Version;
import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.Deployer;
import io.hyperfoil.deploy.k8s.K8sAgent;
import io.hyperfoil.internal.Controller;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import okhttp3.Request;
import okhttp3.Response;

public class K8sDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(K8sDeployer.class);
    private static final String API_SERVER = Properties.get((String)"io.hyperfoil.deployer.k8s.apiserver", (String)"https://kubernetes.default.svc.cluster.local/");
    private static final String DEFAULT_IMAGE = "quay.io/hyperfoil/hyperfoil:" + Version.VERSION;
    private static final String CONTROLLER_POD_NAME = System.getenv("HOSTNAME");
    private static final String NAMESPACE = K8sDeployer.getPropertyOrLoad("io.hyperfoil.deployer.k8s.namespace", "namespace");
    private final ScheduledExecutorService logReader = Executors.newScheduledThreadPool(1);
    private KubernetesClient client;

    private static String getPropertyOrLoad(String property, String file) {
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        String path = "/var/run/secrets/kubernetes.io/serviceaccount/" + file;
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.debug((Object)"Cannot load {} - not running as pod?", (Throwable)e, new Object[]{path});
            return "<cannot load>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClient() {
        K8sDeployer k8sDeployer = this;
        synchronized (k8sDeployer) {
            if (this.client == null) {
                Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(API_SERVER)).withTrustCerts(true)).build();
                this.client = new DefaultKubernetesClient(config);
            }
        }
    }

    public DeployedAgent start(Agent agent, String runId, Benchmark benchmark, Consumer<Throwable> exceptionHandler) {
        String logProperty;
        this.ensureClient();
        PodSpecBuilder spec = new PodSpecBuilder();
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("java");
        int threads = agent.threads() < 0 ? benchmark.defaultThreads() : agent.threads();
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withImage(agent.properties.getOrDefault("image", DEFAULT_IMAGE))).withImagePullPolicy(agent.properties.getOrDefault("imagePullPolicy", "Always"))).withName("hyperfoil-agent")).withPorts(new ContainerPort[]{new ContainerPort(Integer.valueOf(7800), null, null, "jgroups", "TCP")})).withNewResources().withRequests(Collections.singletonMap("cpu", new Quantity(String.valueOf(threads))))).endResources();
        String node = (String)agent.properties.get("node");
        if (node != null) {
            HashMap<String, String> nodeSelector = new HashMap<String, String>();
            for (String label : node.split(",", 0)) {
                if ((label = label.trim()).isEmpty()) continue;
                if (label.contains("=")) {
                    String[] parts = node.split("=", 2);
                    nodeSelector.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                nodeSelector.put("kubernetes.io/hostname", label);
            }
            spec = (PodSpecBuilder)spec.withNodeSelector(nodeSelector);
        }
        if ((logProperty = (String)agent.properties.get("log")) != null) {
            String configMap = logProperty;
            String file = "log4j2.xml";
            if (logProperty.contains("/")) {
                int index = logProperty.indexOf("/");
                configMap = logProperty.substring(0, index);
                file = logProperty.substring(index + 1);
            }
            command.add("-Dlog4j.configurationFile=file:///etc/log4j2/" + file);
            containerBuilder.withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("log")).withMountPath("/etc/log4j2")).withNewReadOnly(true)).build()});
            spec.withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("log")).withConfigMap(new ConfigMapVolumeSource(null, null, configMap, Boolean.valueOf(false)))).build()});
        }
        command.add("-Djava.net.preferIPv4Stack=true");
        command.add("-Dvertx.logger-delegate-factory-class-name=io.vertx.core.logging.Log4j2LogDelegateFactory");
        command.add("-Dio.hyperfoil.agent.name=" + agent.name);
        command.add("-Dio.hyperfoil.runid=" + runId);
        command.add("-Dio.hyperfoil.controller.cluster.ip=" + Properties.get((String)"io.hyperfoil.controller.cluster.ip", null));
        command.add("-Dio.hyperfoil.controller.cluster.port=" + Properties.get((String)"io.hyperfoil.controller.cluster.port", null));
        if (agent.properties.containsKey("extras")) {
            command.addAll(Arrays.asList(((String)agent.properties.get("extras")).split(" ", 0)));
        }
        command.add("-cp");
        command.add("/deployment/lib/*");
        command.add("io.hyperfoil.Hyperfoil$Agent");
        containerBuilder = (ContainerBuilder)containerBuilder.withCommand(command);
        spec = (PodSpecBuilder)spec.withContainers(Collections.singletonList(containerBuilder.build()));
        String podName = "agent-" + runId.toLowerCase() + "-" + agent.name.toLowerCase();
        boolean fetchLogs = !"false".equalsIgnoreCase(agent.properties.getOrDefault("fetchLogs", "true"));
        Path outputPath = null;
        FileOutputStream output = null;
        if (fetchLogs) {
            outputPath = Controller.RUN_DIR.resolve(runId).resolve(podName + ".log");
            try {
                output = new FileOutputStream(outputPath.toFile());
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Cannot write to {}", (Throwable)e, new Object[]{outputPath});
            }
        }
        Pod pod = ((DoneablePod)((DoneablePod)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).createNew()).withNewMetadata().withNamespace(NAMESPACE)).withName(podName)).endMetadata()).withSpec(spec.build())).done();
        boolean stop = !"false".equalsIgnoreCase(agent.properties.getOrDefault("stop", "true"));
        K8sAgent k8sAgent = new K8sAgent(agent, this.client, pod, stop, outputPath, output);
        if (output != null) {
            ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).withName(podName)).watch((Object)new AgentWatcher(podName, k8sAgent));
        }
        return k8sAgent;
    }

    public boolean hasControllerLog() {
        return true;
    }

    public void downloadControllerLog(long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        this.downloadRunningLog(CONTROLLER_POD_NAME, offset, destinationFile, handler);
    }

    public void downloadAgentLog(DeployedAgent deployedAgent, long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        K8sAgent agent = (K8sAgent)deployedAgent;
        this.ensureClient();
        if (agent.outputPath != null) {
            try (FileInputStream stream = new FileInputStream(agent.outputPath.toFile());){
                this.skipBytes(offset, stream);
                Files.copy(stream, Paths.get(destinationFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                handler.handle((Object)Future.succeededFuture());
            }
            catch (IOException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        } else {
            this.downloadRunningLog(agent.pod.getMetadata().getName(), offset, destinationFile, handler);
        }
    }

    private void skipBytes(long offset, InputStream stream) throws IOException {
        long skipped;
        while (offset > 0L && (skipped = stream.skip(offset)) != 0L) {
            offset -= skipped;
        }
    }

    private void downloadRunningLog(String podName, long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        this.ensureClient();
        try {
            PodResource podResource = (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).withName(podName);
            InputStream stream = this.getLog((PodResource<Pod, DoneablePod>)podResource);
            this.skipBytes(offset, stream);
            Files.copy(stream, Paths.get(destinationFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            handler.handle((Object)Future.succeededFuture());
        }
        catch (IOException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private InputStream getLog(PodResource<Pod, DoneablePod> podResource) throws IOException {
        PodOperationsImpl impl = (PodOperationsImpl)podResource;
        URL url = new URL(impl.getResourceUrl().toString() + "/log");
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        Request request = requestBuilder.build();
        Response response = ((HttpClientAware)this.client).getHttpClient().newCall(request).execute();
        return response.body().byteStream();
    }

    public void close() {
        this.client.close();
    }

    private class AgentWatcher
    implements Watcher<Pod> {
        private final String podName;
        private final K8sAgent agent;

        public AgentWatcher(String podName, K8sAgent agent) {
            this.podName = podName;
            this.agent = agent;
        }

        public void eventReceived(Watcher.Action action, Pod resource) {
            if (resource.getStatus().getConditions().stream().filter(c -> "Ready".equalsIgnoreCase(c.getType())).anyMatch(c -> "True".equalsIgnoreCase(c.getStatus()))) {
                if (this.agent.logWatch != null) {
                    return;
                }
                this.agent.logWatch = (LogWatch)((PodResource)((NonNamespaceOperation)K8sDeployer.this.client.pods().inNamespace(NAMESPACE)).withName(this.podName)).watchLog((OutputStream)this.agent.output);
            }
        }

        public void onClose(KubernetesClientException cause) {
        }
    }

    public static class Factory
    implements Deployer.Factory {
        public String name() {
            return "k8s";
        }

        public K8sDeployer create() {
            return new K8sDeployer();
        }
    }
}

