/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.builders.IntConditionBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableIntPredicate;

public class IntCondition
implements Condition {
    private final Access fromVar;
    private final boolean isSet;
    private final SerializableIntPredicate predicate;

    public IntCondition(Access fromVar, boolean isSet, SerializableIntPredicate predicate) {
        this.fromVar = fromVar;
        this.isSet = isSet;
        this.predicate = predicate;
    }

    @Override
    public boolean test(Session session) {
        int value;
        Session.Var var = this.fromVar.getVar(session);
        if (!var.isSet()) {
            return !this.isSet;
        }
        if (!this.isSet) {
            return false;
        }
        if (this.predicate == null) {
            return true;
        }
        if (var.type() == Session.VarType.INTEGER) {
            value = var.intValue(session);
        } else if (var.type() == Session.VarType.OBJECT) {
            value = Integer.parseInt(var.objectValue(session).toString());
        } else {
            throw new IllegalStateException("Unknown type of var: " + var);
        }
        return this.predicate.test(value);
    }

    public static class ProvidedVarBuilder<P>
    extends IntConditionBuilder<ProvidedVarBuilder<P>, P> {
        public ProvidedVarBuilder(P parent) {
            super(parent);
        }

        public IntCondition build(String var) {
            return new IntCondition(SessionFactory.access(var), true, this.buildPredicate());
        }
    }

    public static class Builder<P>
    extends IntConditionBuilder<Builder<P>, P>
    implements Condition.Builder<Builder<P>> {
        private Object fromVar;
        private boolean isSet = true;

        public Builder() {
            this(null);
        }

        public Builder(P parent) {
            super(parent);
        }

        public Builder<P> fromVar(Object var) {
            this.fromVar = var;
            return this;
        }

        public Builder<P> isSet(boolean isSet) {
            this.isSet = isSet;
            return this;
        }

        @Override
        public IntCondition buildCondition() {
            return new IntCondition(SessionFactory.access(this.fromVar), this.isSet, this.buildPredicate());
        }
    }
}

