/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.function.SerializableIntPredicate;

public class IntConditionBuilder<B extends IntConditionBuilder<B, P>, P>
implements BuilderBase<B> {
    protected final P parent;
    protected Integer equalTo;
    protected Integer notEqualTo;
    protected Integer greaterThan;
    protected Integer greaterOrEqualTo;
    protected Integer lessThan;
    protected Integer lessOrEqualTo;

    protected static SerializableIntPredicate and(SerializableIntPredicate p1, SerializableIntPredicate p2) {
        return p1 == null ? p2 : (p2 == null ? null : new And(p1, p2));
    }

    public IntConditionBuilder() {
        this(null);
    }

    public IntConditionBuilder(P parent) {
        this.parent = parent;
    }

    private B self() {
        return (B)this;
    }

    public B equalTo(int equalTo) {
        this.equalTo = equalTo;
        return this.self();
    }

    public B notEqualTo(int notEqualTo) {
        this.notEqualTo = notEqualTo;
        return this.self();
    }

    public B greaterThan(int greaterThan) {
        this.greaterThan = greaterThan;
        return this.self();
    }

    public B greaterOrEqualTo(int greaterOrEqualTo) {
        this.greaterOrEqualTo = greaterOrEqualTo;
        return this.self();
    }

    public B lessThan(int lessThan) {
        this.lessThan = lessThan;
        return this.self();
    }

    public B lessOrEqualTo(int lessOrEqualTo) {
        this.lessOrEqualTo = lessOrEqualTo;
        return this.self();
    }

    protected SerializableIntPredicate buildPredicate() {
        SerializableIntPredicate predicate = null;
        if (this.equalTo != null) {
            predicate = new EqualTo(this.equalTo);
        }
        if (this.notEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new NotEqualTo(this.notEqualTo));
        }
        if (this.greaterThan != null) {
            predicate = IntConditionBuilder.and(predicate, new GreaterThan(this.greaterThan));
        }
        if (this.greaterOrEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new GreaterOrEqualTo(this.greaterOrEqualTo));
        }
        if (this.lessThan != null) {
            predicate = IntConditionBuilder.and(predicate, new LessThan(this.lessThan));
        }
        if (this.lessOrEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new LessOrEqualTo(this.lessOrEqualTo));
        }
        return predicate;
    }

    public P end() {
        return this.parent;
    }

    private static class LessOrEqualTo
    implements SerializableIntPredicate {
        private final int val;

        public LessOrEqualTo(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v <= this.val;
        }
    }

    private static class LessThan
    implements SerializableIntPredicate {
        private final int val;

        public LessThan(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v < this.val;
        }
    }

    private static class GreaterOrEqualTo
    implements SerializableIntPredicate {
        private final int val;

        public GreaterOrEqualTo(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v >= this.val;
        }
    }

    private static class GreaterThan
    implements SerializableIntPredicate {
        private final int val;

        public GreaterThan(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v > this.val;
        }
    }

    private static class NotEqualTo
    implements SerializableIntPredicate {
        private final int val;

        public NotEqualTo(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v != this.val;
        }
    }

    private static class EqualTo
    implements SerializableIntPredicate {
        private final int val;

        public EqualTo(int val) {
            this.val = val;
        }

        @Override
        public boolean test(int v) {
            return v == this.val;
        }
    }

    private static class And
    implements SerializableIntPredicate {
        private final SerializableIntPredicate p1;
        private final SerializableIntPredicate p2;

        public And(SerializableIntPredicate p1, SerializableIntPredicate p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public boolean test(int x) {
            return this.p1.test(x) && this.p2.test(x);
        }
    }
}

