/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.builders.StringConditionBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiPredicate;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class StringCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(StringCondition.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Access fromVar;
    private final boolean isSet;
    private final SerializableBiPredicate<Session, CharSequence> predicate;

    public StringCondition(Access fromVar, boolean isSet, SerializableBiPredicate<Session, CharSequence> predicate) {
        this.fromVar = fromVar;
        this.isSet = isSet;
        this.predicate = predicate;
    }

    @Override
    public boolean test(Session session) {
        CharSequence value;
        Session.Var var = this.fromVar.getVar(session);
        if (!var.isSet()) {
            if (trace) {
                log.trace((Object)"#{} Variable {} is not set, condition result: {}", new Object[]{session.uniqueId(), this.fromVar, !this.isSet});
            }
            return !this.isSet;
        }
        if (!this.isSet) {
            if (trace) {
                log.trace((Object)"#{} Variable {} is set, condition result: false", new Object[]{session.uniqueId(), this.fromVar});
            }
            return false;
        }
        if (this.predicate == null) {
            if (trace) {
                log.trace((Object)"#{} No predicate on variable {}, condition result: true", new Object[]{session.uniqueId(), this.fromVar});
            }
            return true;
        }
        if (var.type() == Session.VarType.INTEGER) {
            value = String.valueOf(var.intValue(session));
        } else if (var.type() == Session.VarType.OBJECT) {
            Object obj = var.objectValue(session);
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            value = (CharSequence)obj;
        } else {
            throw new IllegalStateException("Unknown type of var: " + var);
        }
        boolean result = this.predicate.test(session, value);
        if (trace) {
            log.trace((Object)"#{} Variable {} = {}, condition result: {}", new Object[]{session.uniqueId(), this.fromVar, value, result});
        }
        return result;
    }

    public static class Builder<P>
    extends StringConditionBuilder<Builder<P>, P>
    implements Condition.Builder<Builder<P>> {
        private Object fromVar;
        private boolean isSet = true;

        public Builder(P parent) {
            super(parent);
        }

        public Builder<P> fromVar(Object var) {
            this.fromVar = var;
            return this;
        }

        public Builder<P> isSet(boolean isSet) {
            this.isSet = isSet;
            return this;
        }

        @Override
        public StringCondition buildCondition() {
            return new StringCondition(SessionFactory.access(this.fromVar), this.isSet, this.isSet ? this.buildPredicate() : null);
        }
    }
}

