/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.data;

import io.hyperfoil.api.collection.LimitedPool;
import io.hyperfoil.api.session.Session;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Supplier;

public class LimitedPoolResource<T>
extends LimitedPool<T>
implements Session.Resource {
    protected final Object[] originalObjects;

    private LimitedPoolResource(T[] array) {
        super(array);
        this.originalObjects = array;
    }

    protected LimitedPoolResource(int capacity, Class<T> clz, Supplier<T> init) {
        this(LimitedPoolResource.createArray(capacity, clz, init));
    }

    public static <T> LimitedPoolResource<T> create(int capacity, Class<T> clz, Supplier<T> init) {
        return new LimitedPoolResource<T>(LimitedPoolResource.createArray(capacity, clz, init));
    }

    private static <T> T[] createArray(int capacity, Class<T> clz, Supplier<T> init) {
        Object[] array = (Object[])Array.newInstance(clz, capacity);
        Arrays.setAll(array, i -> init.get());
        return array;
    }

    @Override
    public void onSessionReset(Session session) {
        this.reset(this.originalObjects);
    }

    public static class Key<T>
    implements Session.ResourceKey<LimitedPoolResource<T>> {
    }
}

