/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.ObjectVar;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Objects;

public class Queue
implements Session.Resource {
    private static final Logger log = LoggerFactory.getLogger(Queue.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Access var;
    private final Object[] data;
    private final int concurrency;
    private final String sequence;
    private final Action onCompletion;
    private int head;
    private int tail;
    private int active;
    private int size;
    private boolean producerComplete;

    public Queue(Access var, int size, int concurrency, String sequence, Action onCompletion) {
        if (var.isSequenceScoped()) {
            throw new BenchmarkDefinitionException("Queue variable should not be sequence-scoped for queue; use sequence-scoped access only for reading.");
        }
        this.var = var;
        this.data = new Object[size];
        this.concurrency = concurrency;
        this.sequence = sequence;
        this.onCompletion = onCompletion;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public void onSessionReset(Session session) {
        this.reset(session);
    }

    public void reset(Session session) {
        this.active = 0;
        this.head = 0;
        this.tail = 0;
        this.size = 0;
        this.producerComplete = false;
        Arrays.fill(this.data, null);
        this.var.activate(session);
    }

    public void push(Session session, Object value) {
        log.trace((Object)"#{} adding {} to queue -> {}", new Object[]{session.uniqueId(), value, this.var});
        Objects.requireNonNull(value);
        if (this.size < this.data.length) {
            this.data[this.tail++] = value;
            if (this.tail >= this.data.length) {
                this.tail = 0;
            }
            ++this.size;
        } else {
            log.error((Object)"#{} Exceeded maximum size of queue {} ({}), dropping value {}", new Object[]{session.uniqueId(), this.var, this.data.length, value});
        }
        if (this.active < this.concurrency && this.size > 0) {
            ++this.active;
            --this.size;
            Object queuedValue = this.data[this.head];
            this.data[this.head++] = null;
            if (this.head >= this.data.length) {
                this.head = 0;
            }
            SequenceInstance instance = session.startSequence(this.sequence, false, Session.ConcurrencyPolicy.FAIL);
            if (trace) {
                log.trace((Object)"#{} starting {} with queued value {} in {}[{}]", new Object[]{session.uniqueId(), this.sequence, queuedValue, this.var, instance.index()});
            }
            ObjectVar[] output = (ObjectVar[])this.var.getObject(session);
            output[instance.index()].set(queuedValue);
        }
    }

    public void producerComplete(Session session) {
        log.trace((Object)"#{} producer of {} is complete", new Object[]{session.uniqueId(), this.var});
        this.producerComplete = true;
        if (this.active == 0) {
            this.complete(session);
        }
    }

    public void consumed(Session session) {
        SequenceInstance instance = session.currentSequence();
        if (trace) {
            log.trace((Object)"#{} consumed {}[{}], head={}, tail={}", new Object[]{session.uniqueId(), this.var, instance.index(), this.head, this.tail});
        }
        if (this.head < this.tail) {
            Object queuedValue = this.data[this.head];
            this.data[this.head++] = null;
            assert (instance.definition().name().equals(this.sequence));
            ObjectVar[] output = (ObjectVar[])this.var.getObject(session);
            output[instance.index()].set(queuedValue);
            if (trace) {
                log.trace((Object)"#{} restarting sequence {}[{}] with {} -> {}", new Object[]{this.sequence, instance.index(), queuedValue, this.var});
            }
            instance.restart(session);
        } else {
            --this.active;
            if (this.producerComplete && this.active == 0) {
                this.complete(session);
            }
        }
    }

    private void complete(Session session) {
        assert (this.head == this.tail);
        log.trace((Object)"#{} queue {} completed", new Object[]{session.uniqueId(), this.var});
        this.reset(session);
        if (this.onCompletion != null) {
            this.onCompletion.run(session);
        }
    }

    public static class Key
    implements Session.ResourceKey<Queue> {
    }
}

