/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.handlers.DefragTransformer;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ActionsTransformer
implements Transformer,
ResourceUtilizer {
    private final Access var;
    private final DataFormat format;
    private final Action[] actions;
    private final Pattern pattern;

    public ActionsTransformer(Access var, DataFormat format, Action[] actions, Pattern pattern) {
        this.var = var;
        this.format = format;
        this.actions = actions;
        this.pattern = pattern;
    }

    @Override
    public void transform(Session session, ByteBuf in, int offset, int length, boolean lastFragment, ByteBuf out) {
        assert (lastFragment);
        this.var.setObject(session, this.format.convert(in, offset, length));
        for (Action action : this.actions) {
            action.run(session);
        }
        this.pattern.accept(session, out);
    }

    @Override
    public void reserve(Session session) {
        this.var.declareObject(session);
        ResourceUtilizer.reserve(session, this.actions);
    }

    @Name(value="actions")
    public static class Builder
    implements Transformer.Builder {
        private String var;
        private DataFormat format = DataFormat.STRING;
        private String pattern;
        private List<Action.Builder> actions = new ArrayList<Action.Builder>();

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        private Builder actions(List<Action.Builder> actions) {
            this.actions = actions;
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> actions() {
            return new ServiceLoadedBuilderProvider<Action.Builder>(Action.Builder.class, this.actions::add);
        }

        @Override
        public Transformer build(boolean fragmented) {
            if (this.var == null) {
                throw new BenchmarkDefinitionException("Missing variable name");
            }
            if (this.actions.isEmpty()) {
                throw new BenchmarkDefinitionException("No actions; use `store` processor instead.");
            }
            ActionsTransformer transformer = new ActionsTransformer(SessionFactory.access(this.var), this.format, (Action[])this.actions.stream().map(Action.Builder::build).toArray(Action[]::new), new Pattern(this.pattern, false));
            return fragmented ? transformer : new DefragTransformer(transformer);
        }
    }
}

