/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;

public class IntValueProviderBuilder<P>
implements InitFromParam<IntValueProviderBuilder<P>> {
    private final P parent;
    private final Integer defaultValue;
    private Integer value;
    private String fromVar;

    public IntValueProviderBuilder(P parent, Integer defaultValue) {
        this.parent = parent;
        this.defaultValue = defaultValue;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public IntValueProviderBuilder<P> init(String param) {
        try {
            this.value = Integer.parseInt(param.trim());
        }
        catch (NumberFormatException e) {
            throw new BenchmarkDefinitionException("Cannot convert " + param + " to integer value.");
        }
        return this;
    }

    public IntValueProviderBuilder<P> value(int value) {
        this.value = value;
        return this;
    }

    public IntValueProviderBuilder<P> fromVar(String fromVar) {
        this.fromVar = fromVar;
        return this;
    }

    public SerializableToIntFunction<Session> build() {
        if (this.value == null && this.fromVar == null && this.defaultValue == null) {
            throw new BenchmarkDefinitionException("Must set either 'value' or 'fromVar'.");
        }
        if (this.value != null && this.fromVar != null) {
            throw new BenchmarkDefinitionException("Must set one of: 'value' or 'fromVar'.");
        }
        if (this.fromVar != null) {
            Access access = SessionFactory.access(this.fromVar);
            return access::getInt;
        }
        int unbox = this.value == null ? this.defaultValue : this.value;
        return new ConstValue(unbox);
    }

    private int assertionValue() {
        if (this.value == null && this.defaultValue == null) {
            return 0;
        }
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public int compareTo(IntValueProviderBuilder<?> other) {
        if (this.fromVar != null || other.fromVar != null) {
            return 0;
        }
        int v1 = this.assertionValue();
        int v2 = other.assertionValue();
        return Integer.compare(v1, v2);
    }

    private static class ConstValue
    implements SerializableToIntFunction<Session> {
        private final int value;

        private ConstValue(int value) {
            this.value = value;
        }

        @Override
        public int applyAsInt(Session session) {
            return this.value;
        }
    }
}

