/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.function.SerializableFunction;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class Pattern
implements SerializableFunction<Session, String>,
SerializableBiConsumer<Session, ByteBuf>,
Transformer {
    private static final int VAR_LENGTH_ESTIMATE = 32;
    private final Component[] components;
    @Visitor.Ignore
    private int lengthEstimate;
    private final boolean urlEncode;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(String str, boolean urlEncode) {
        this.urlEncode = urlEncode;
        ArrayList<Component> components = new ArrayList<Component>();
        int last = 0;
        int lastSearch = 0;
        while (true) {
            String substring;
            int openPar;
            if ((openPar = str.indexOf("${", lastSearch)) < 0) {
                substring = str.substring(last);
                if (str.isEmpty()) break;
                components.add(new StringComponent(substring.replaceAll("\\$\\$\\{", "\\${")));
                this.lengthEstimate += substring.length();
                break;
            }
            if (openPar > 0 && str.charAt(openPar - 1) == '$') {
                lastSearch = openPar + 1;
                continue;
            }
            substring = str.substring(last, openPar);
            components.add(new StringComponent(substring.replaceAll("\\$\\$\\{", "\\${")));
            this.lengthEstimate += substring.length() + 32;
            int closePar = str.indexOf("}", openPar);
            int colon = str.indexOf(":", openPar);
            if (colon >= 0 && colon < closePar) {
                String format = str.substring(openPar + 2, colon).trim();
                Access key = SessionFactory.access(str.substring(colon + 1, closePar).trim());
                if (format.equalsIgnoreCase("urlencode")) {
                    if (urlEncode) {
                        throw new BenchmarkDefinitionException("It seems you're trying to URL-encode value twice.");
                    }
                    components.add(new VarComponent(key, true));
                } else {
                    if (!format.endsWith("d") && !format.endsWith("o") && !format.endsWith("x") && !format.endsWith("X")) throw new IllegalArgumentException("Cannot use format string '" + format + "', only integers are supported");
                    components.add(new FormatIntComponent(format, key));
                }
            } else {
                Access key = SessionFactory.access(str.substring(openPar + 2, closePar).trim());
                components.add(new VarComponent(key, urlEncode));
            }
            lastSearch = last = closePar + 1;
        }
        this.components = components.toArray(new Component[0]);
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String apply(Session session) {
        if (this.components.length == 1 && this.components[0] instanceof StringComponent) {
            return ((StringComponent)this.components[0]).substring;
        }
        StringBuilder sb = new StringBuilder(this.lengthEstimate);
        for (Component c : this.components) {
            c.accept(session, sb);
        }
        return sb.toString();
    }

    @Override
    public void accept(Session session, ByteBuf byteBuf) {
        for (Component c : this.components) {
            c.accept(session, byteBuf);
        }
    }

    @Override
    public void transform(Session session, ByteBuf in, int offset, int length, boolean lastFragment, ByteBuf out) {
        if (lastFragment) {
            this.accept(session, out);
        }
    }

    public Generator generator() {
        return new Generator();
    }

    private static class VarComponent
    implements Component {
        private final Access key;
        private final boolean urlEncode;

        VarComponent(Access key, boolean urlEncode) {
            this.key = key;
            this.urlEncode = urlEncode;
        }

        @Override
        public void accept(Session session, StringBuilder sb) {
            Session.Var var = this.key.getVar(session);
            if (!var.isSet()) {
                throw new IllegalArgumentException("Variable " + this.key + " is not set!");
            }
            switch (var.type()) {
                case OBJECT: {
                    String str = String.valueOf(var.objectValue(session));
                    if (this.urlEncode) {
                        str = Pattern.urlEncode(str);
                    }
                    sb.append(str);
                    break;
                }
                case INTEGER: {
                    sb.append(var.intValue(session));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown var type: " + var);
                }
            }
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            Session.Var var = this.key.getVar(session);
            if (!var.isSet()) {
                throw new IllegalArgumentException("Variable " + this.key + " is not set!");
            }
            switch (var.type()) {
                case OBJECT: {
                    Object o = var.objectValue(session);
                    if (o == null) break;
                    if (this.urlEncode) {
                        Util.urlEncode(o.toString(), buf);
                        break;
                    }
                    CharSequence str = o instanceof CharSequence ? (CharSequence)o : o.toString();
                    Util.string2byteBuf(str, buf);
                    break;
                }
                case INTEGER: {
                    Util.intAsText2byteBuf(var.intValue(session), buf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown var type: " + var);
                }
            }
        }
    }

    private class FormatIntComponent
    implements Component {
        private final String format;
        private final Access key;

        FormatIntComponent(String format, Access key) {
            this.format = format;
            this.key = key;
        }

        private String string(Session session) {
            return String.format(this.format, this.key.getInt(session));
        }

        @Override
        public void accept(Session s, StringBuilder sb) {
            String str = this.string(s);
            sb.append(Pattern.this.urlEncode ? Pattern.urlEncode(str) : str);
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            String str = this.string(session);
            if (Pattern.this.urlEncode) {
                Util.urlEncode(str, buf);
            } else {
                Util.string2byteBuf(str, buf);
            }
        }
    }

    private class StringComponent
    implements Component {
        private final String substring;
        @Visitor.Ignore
        private final byte[] bytes;

        StringComponent(String substring) {
            if (Pattern.this.urlEncode) {
                substring = Pattern.urlEncode(substring);
            }
            this.substring = substring;
            this.bytes = substring.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void accept(Session s, StringBuilder sb) {
            sb.append(this.substring);
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            buf.writeBytes(this.bytes);
        }
    }

    private class Generator
    implements SerializableBiFunction<Session, Connection, ByteBuf> {
        private Generator() {
        }

        @Override
        public ByteBuf apply(Session session, Connection connection) {
            ByteBuf buffer = connection.context().alloc().buffer(Pattern.this.lengthEstimate);
            Pattern.this.accept(session, buffer);
            return buffer;
        }
    }

    static interface Component
    extends Serializable {
        public void accept(Session var1, StringBuilder var2);

        public void accept(Session var1, ByteBuf var2);
    }
}

