/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

public class RandomCsvRowStep
implements Step,
ResourceUtilizer {
    private String[][] rows;
    private final Access[] columnVars;

    public RandomCsvRowStep(String[][] rows, Access[] columnVars) {
        this.rows = rows;
        this.columnVars = columnVars;
    }

    @Override
    public boolean invoke(Session session) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String[] row = this.rows[random.nextInt(this.rows.length)];
        int j = 0;
        for (int i = 0; i < this.columnVars.length; ++i) {
            this.columnVars[j++].setObject(session, row[i]);
        }
        return true;
    }

    @Override
    public void reserve(Session session) {
        Arrays.asList(this.columnVars).forEach(var -> var.declareObject(session));
    }

    @Name(value="randomCsvRow")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String file;
        private boolean skipComments;
        private boolean removeQuotes;
        private List<String> builderColumns = new ArrayList<String>();

        @Override
        public List<Step> build() {
            List<Step> list;
            block12: {
                int[] srcIndex = new int[(int)this.builderColumns.stream().filter(Objects::nonNull).count()];
                int next = 0;
                for (int i = 0; i < this.builderColumns.size(); ++i) {
                    if (this.builderColumns.get(i) == null) continue;
                    srcIndex[next++] = i;
                }
                assert (next == srcIndex.length);
                InputStream inputStream = Locator.current().benchmark().data().readFile(this.file);
                try {
                    String[][] rows;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    Stream<String> lines = reader.lines();
                    if (this.skipComments) {
                        lines = lines.filter(line -> !line.trim().startsWith("#"));
                    }
                    if ((rows = (String[][])lines.map(line -> {
                        if (this.removeQuotes) {
                            line = line.replaceAll("\"", "");
                        }
                        String[] cols = line.split(",");
                        String[] arr = new String[srcIndex.length];
                        for (int i = 0; i < arr.length; ++i) {
                            arr[i] = cols[srcIndex[i]];
                        }
                        return arr;
                    }).toArray(x$0 -> new String[x$0][])).length == 0) {
                        throw new BenchmarkDefinitionException("Missing CSV row data. Rows were not detected after initial processing of file.");
                    }
                    Access[] columnVars = (Access[])this.builderColumns.stream().filter(Objects::nonNull).map(SessionFactory::access).toArray(Access[]::new);
                    list = Collections.singletonList(new RandomCsvRowStep(rows, columnVars));
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new BenchmarkDefinitionException("Failed to read file " + this.file, ioe);
                    }
                }
                inputStream.close();
            }
            return list;
        }

        public ColumnsBuilder columns() {
            return new ColumnsBuilder();
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder skipComments(boolean skipComments) {
            this.skipComments = skipComments;
            return this;
        }

        public Builder removeQuotes(boolean removeQuotes) {
            this.removeQuotes = removeQuotes;
            return this;
        }

        public class ColumnsBuilder
        extends PairBuilder.OfString {
            @Override
            public void accept(String position, String columnVar) {
                int pos = Integer.parseInt(position);
                if (pos < 0) {
                    throw new BenchmarkDefinitionException("Negative column index is not supported.");
                }
                while (pos >= Builder.this.builderColumns.size()) {
                    Builder.this.builderColumns.add(null);
                }
                String prev = Builder.this.builderColumns.set(pos, columnVar);
                if (prev != null) {
                    throw new BenchmarkDefinitionException("Column " + pos + " is already mapped to '" + prev + "', don't map to '" + columnVar + "'");
                }
            }
        }
    }
}

