/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.WeightedGenerator;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RandomFileStep
implements Step,
ResourceUtilizer {
    private final WeightedGenerator generator;
    private final byte[][] fileBytes;
    private final Access toVar;
    private final Access filenameVar;

    public RandomFileStep(WeightedGenerator generator, byte[][] fileBytes, Access toVar, Access filenameVar) {
        this.generator = generator;
        this.fileBytes = fileBytes;
        this.toVar = toVar;
        this.filenameVar = filenameVar;
    }

    @Override
    public boolean invoke(Session session) {
        int index = this.generator.randomIndex();
        this.toVar.setObject(session, this.fileBytes[index]);
        if (this.filenameVar != null) {
            this.filenameVar.setObject(session, this.generator.items()[index]);
        }
        return true;
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareObject(session);
        if (this.filenameVar != null) {
            this.filenameVar.declareObject(session);
        }
    }

    @Name(value="randomFile")
    public static class Builder
    implements StepBuilder<Builder> {
        private String toVar;
        private WeightedGenerator.Builder weighted = new WeightedGenerator.Builder();
        private String filenameVar;

        public WeightedGenerator.Builder files() {
            return this.weighted;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public Builder filenameVar(String var) {
            this.filenameVar = var;
            return this;
        }

        @Override
        public List<Step> build() {
            WeightedGenerator generator = this.weighted.build();
            BenchmarkData data = Locator.current().benchmark().data();
            ArrayList<byte[]> fileBytes = new ArrayList<byte[]>();
            for (String file : generator.items()) {
                try {
                    fileBytes.add(Util.toByteArray(data.readFile(file)));
                }
                catch (IOException e) {
                    throw new BenchmarkDefinitionException("Cannot read bytes from file " + file);
                }
            }
            return Collections.singletonList(new RandomFileStep(generator, (byte[][])fileBytes.toArray((T[])new byte[0][]), SessionFactory.access(this.toVar), SessionFactory.access(this.filenameVar)));
        }
    }
}

