/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.generators.StringGeneratorBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public class StringGeneratorImplBuilder<T>
implements StringGeneratorBuilder,
InitFromParam<StringGeneratorImplBuilder<T>> {
    private static final Logger log = LoggerFactory.getLogger(StringGeneratorImplBuilder.class);
    private final T parent;
    private final boolean urlEncode;
    private Supplier<SerializableFunction<Session, String>> supplier;

    public StringGeneratorImplBuilder(T parent, boolean urlEncode) {
        this.parent = parent;
        this.urlEncode = urlEncode;
    }

    @Override
    public StringGeneratorImplBuilder<T> init(String param) {
        return this.pattern(param);
    }

    private void set(Supplier<SerializableFunction<Session, String>> function) {
        if (this.supplier != null) {
            throw new BenchmarkDefinitionException("Specify only one of: value, var, pattern");
        }
        this.supplier = function;
    }

    public StringGeneratorImplBuilder<T> value(String value) {
        if (this.urlEncode) {
            try {
                String encoded = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                this.set(() -> session -> encoded);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.set(() -> session -> value);
        }
        return this;
    }

    public StringGeneratorImplBuilder<T> fromVar(Object var) {
        boolean urlEncode = this.urlEncode;
        this.set(() -> {
            Access access = SessionFactory.access(var);
            return session -> {
                Object value = access.getObject((Session)session);
                if (value instanceof String) {
                    if (urlEncode) {
                        try {
                            return URLEncoder.encode((String)value, StandardCharsets.UTF_8.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    return (String)value;
                }
                log.error((Object)"Cannot retrieve string from {}, the content is {}", new Object[]{var, value});
                return null;
            };
        });
        return this;
    }

    public StringGeneratorImplBuilder<T> pattern(String pattern) {
        this.set(() -> new Pattern(pattern, this.urlEncode));
        return this;
    }

    public T end() {
        return this.parent;
    }

    @Override
    public SerializableFunction<Session, String> build() {
        return this.supplier.get();
    }
}

