/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.session.SessionFactory;
import java.util.Collections;
import java.util.List;

public class TemplateStep
implements Step,
ResourceUtilizer {
    private final Pattern pattern;
    private final Access toVar;

    public TemplateStep(Pattern pattern, Access toVar) {
        this.pattern = pattern;
        this.toVar = toVar;
    }

    @Override
    public boolean invoke(Session session) {
        this.toVar.setObject(session, this.pattern.apply(session));
        return true;
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareObject(session);
    }

    @Name(value="template")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String pattern;
        private String toVar;

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        @Override
        public List<Step> build() {
            if (this.pattern == null) {
                throw new BenchmarkDefinitionException("Missing pattern for template.");
            }
            if (this.toVar == null) {
                throw new BenchmarkDefinitionException("Missing target var for template.");
            }
            return Collections.singletonList(new TemplateStep(new Pattern(this.pattern, false), SessionFactory.access(this.toVar)));
        }
    }
}

