/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RequestProcessorBuilder;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class ArrayRecorder
implements Processor,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(ArrayRecorder.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Access toVar;
    private final DataFormat format;
    private final int maxSize;

    public ArrayRecorder(Access toVar, DataFormat format, int maxSize) {
        this.toVar = toVar;
        this.format = format;
        this.maxSize = maxSize;
    }

    @Override
    public void before(Session session) {
        ObjectVar[] array = (ObjectVar[])this.toVar.activate(session);
        for (int i = 0; i < array.length; ++i) {
            array[i].unset();
        }
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.ensureDefragmented(isLastPart);
        ObjectVar[] array = (ObjectVar[])this.toVar.activate(session);
        Object value = this.format.convert(data, offset, length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].isSet()) continue;
            if (trace) {
                log.trace((Object)"#{} Set {}[{}] <- {}", new Object[]{session.uniqueId(), this.toVar.toString(), i, value});
            }
            array[i].set(value);
            return;
        }
        log.warn((Object)"Exceed maximum size of the array {} ({}), dropping value {}", new Object[]{this.toVar, this.maxSize, value});
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareObject(session);
        this.toVar.setObject(session, ObjectVar.newArray(session, this.maxSize));
        this.toVar.unset(session);
    }

    @Name(value="array")
    public static class Builder
    implements RequestProcessorBuilder,
    InitFromParam<Builder> {
        private String toVar;
        private DataFormat format = DataFormat.STRING;
        private int maxSize;

        @Override
        public Builder init(String param) {
            int b1 = param.indexOf(91);
            int b2 = param.indexOf(93);
            if (b1 < 0 || b2 < 0 || b2 - b1 < 1) {
                throw new BenchmarkDefinitionException("Array variable must have maximum size: use var[maxSize], e.g. 'foo[16]'");
            }
            try {
                this.maxSize = Integer.parseInt(param.substring(b1 + 1, b2));
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Cannot parse maximum size in '" + param + "'");
            }
            this.toVar = param.substring(0, b1).trim();
            return this;
        }

        @Override
        public Processor build(boolean fragmented) {
            ArrayRecorder arrayRecorder = new ArrayRecorder(SessionFactory.access(this.toVar), this.format, this.maxSize);
            return fragmented ? new DefragProcessor(arrayRecorder) : arrayRecorder;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }
    }
}

