/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseDelegatingAction
implements Action,
ResourceUtilizer {
    protected final Action[] actions;

    public BaseDelegatingAction(Action[] actions) {
        this.actions = actions;
    }

    @Override
    public void run(Session session) {
        for (Action a : this.actions) {
            a.run(session);
        }
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.actions);
    }

    public static abstract class Builder<S extends Builder<S>>
    implements Action.Builder {
        protected final List<Action.Builder> actions = new ArrayList<Action.Builder>();

        protected S self() {
            return (S)this;
        }

        public S action(Action.Builder action) {
            this.actions.add(action);
            return this.self();
        }

        public S actions(Collection<? extends Action.Builder> actions) {
            this.actions.addAll(actions);
            return this.self();
        }

        public ServiceLoadedBuilderProvider<Action.Builder> actions() {
            return new ServiceLoadedBuilderProvider<Action.Builder>(Action.Builder.class, this.actions::add);
        }

        protected Action[] buildActions() {
            return (Action[])this.actions.stream().map(Action.Builder::build).toArray(Action[]::new);
        }
    }
}

