/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.handlers.BaseDelegatingAction;

public class ConditionalAction
extends BaseDelegatingAction {
    private final Condition condition;

    public ConditionalAction(Condition condition, Action[] actions) {
        super(actions);
        this.condition = condition;
    }

    @Override
    public void run(Session session) {
        if (this.condition.test(session)) {
            super.run(session);
        }
    }

    @Name(value="conditional")
    public static class Builder
    extends BaseDelegatingAction.Builder<Builder> {
        private Condition.TypesBuilder<Builder> condition = new Condition.TypesBuilder<Builder>(this);

        @Embed
        public Condition.TypesBuilder<Builder> condition() {
            return this.condition;
        }

        @Override
        public Action build() {
            Condition condition = this.condition.buildCondition();
            if (condition == null) {
                throw new BenchmarkDefinitionException("Conditional action requires a condition.");
            }
            return new ConditionalAction(condition, this.buildActions());
        }
    }
}

