/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class DefragProcessor
extends Processor.BaseDelegating
implements Session.ResourceKey<Context> {
    private static final Logger log = LoggerFactory.getLogger(DefragProcessor.class);

    public DefragProcessor(Processor delegate) {
        super(delegate);
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Context ctx = session.getResource(this);
        if (isLastPart && !ctx.isBuffering()) {
            this.delegate.process(session, data, offset, length, true);
            return;
        }
        if (data.isReadable()) {
            ctx.buffer(data, offset, length);
        }
        if (isLastPart) {
            ctx.flush(session, this.delegate);
        }
    }

    @Override
    public void reserve(Session session) {
        session.declareResource(this, Context::new);
        ResourceUtilizer.reserve(session, (Object)this.delegate);
    }

    static class Context
    implements Session.Resource {
        CompositeByteBuf composite = null;

        Context() {
        }

        boolean isBuffering() {
            return this.composite != null && this.composite.isReadable();
        }

        public void buffer(ByteBuf data, int offset, int length) {
            log.debug((Object)"Buffering {} bytes", new Object[]{length});
            if (this.composite == null) {
                this.composite = new CompositeByteBuf(data.alloc(), data.isDirect(), 16);
            }
            this.composite.addComponent(true, data.retainedSlice(offset, length));
        }

        void flush(Session session, Processor processor) {
            log.debug((Object)"Flushing {} bytes", new Object[]{this.composite.writerIndex()});
            processor.process(session, (ByteBuf)this.composite, 0, this.composite.writerIndex(), true);
            this.composite.readerIndex(this.composite.writerIndex());
            this.composite.discardReadComponents();
        }
    }
}

