/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiProcessor
implements Processor,
ResourceUtilizer {
    protected final Processor[] delegates;

    @SafeVarargs
    public MultiProcessor(Processor ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public void before(Session session) {
        for (Processor p : this.delegates) {
            p.before(session);
        }
    }

    @Override
    public void after(Session session) {
        for (Processor p : this.delegates) {
            p.after(session);
        }
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        for (Processor p : this.delegates) {
            p.process(session, data, offset, length, isLastPart);
        }
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.delegates);
    }

    public static class Builder<S extends Builder<S>>
    implements Processor.Builder<S> {
        public final List<Processor.Builder<?>> delegates = new ArrayList();

        @Override
        public Processor build(boolean fragmented) {
            Processor[] delegates = this.buildProcessors(fragmented);
            return new MultiProcessor(delegates);
        }

        protected Processor[] buildProcessors(boolean fragmented) {
            Processor[] delegates = (Processor[])this.delegates.stream().map(d -> d.build(fragmented)).toArray(Processor[]::new);
            return delegates;
        }

        public S processor(Processor.Builder<?> processor) {
            this.delegates.add(processor);
            return this.self();
        }

        public S processors(Collection<? extends Processor.Builder<?>> processors) {
            this.delegates.addAll(processors);
            return this.self();
        }

        protected S self() {
            return (S)this;
        }
    }
}

