/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RequestProcessorBuilder;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;

public class QueueProcessor
implements Processor,
ResourceUtilizer {
    private final Access var;
    private final int maxSize;
    private final DataFormat format;
    private final String sequence;
    private final int concurrency;
    private final Action onCompletion;
    private final Session.ResourceKey<Queue> key;

    public QueueProcessor(Session.ResourceKey<Queue> key, Access var, int maxSize, DataFormat format, String sequence, int concurrency, Action onCompletion) {
        this.key = key;
        this.var = var;
        this.maxSize = maxSize;
        this.format = format;
        this.sequence = sequence;
        this.concurrency = concurrency;
        this.onCompletion = onCompletion;
    }

    @Override
    public void before(Session session) {
        Queue queue = session.getResource(this.key);
        queue.reset(session);
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.ensureDefragmented(isLastPart);
        Queue queue = session.getResource(this.key);
        Object value = this.format.convert(data, offset, length);
        queue.push(session, value);
    }

    @Override
    public void after(Session session) {
        Queue queue = session.getResource(this.key);
        queue.producerComplete(session);
    }

    @Override
    public void reserve(Session session) {
        this.var.declareObject(session);
        if (!this.var.isSet(session)) {
            this.var.setObject(session, ObjectVar.newArray(session, this.concurrency));
        }
        session.declareResource(this.key, () -> new Queue(this.var, this.maxSize, this.concurrency, this.sequence, this.onCompletion), true);
        ResourceUtilizer.reserve(session, (Object)this.onCompletion);
    }

    @Name(value="queue")
    public static class Builder
    implements RequestProcessorBuilder {
        private String var;
        private int maxSize;
        private DataFormat format = DataFormat.STRING;
        private int concurrency;
        private String sequence;
        private Action.Builder onCompletion;
        private Access varAccess;
        private Queue.Key key;
        private SequenceBuilder sequenceBuilder;
        private Consumer<Action.Builder> sequenceCompletion;

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder sequence(SequenceBuilder sequenceBuilder, Consumer<Action.Builder> sequenceCompletion) {
            this.sequenceBuilder = sequenceBuilder;
            this.sequenceCompletion = sequenceCompletion;
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> onCompletion() {
            return new ServiceLoadedBuilderProvider<Action.Builder>(Action.Builder.class, this::onCompletion);
        }

        public Builder onCompletion(Action.Builder onCompletion) {
            this.onCompletion = onCompletion;
            return this;
        }

        @Override
        public void prepareBuild() {
            if (this.var == null) {
                throw new BenchmarkDefinitionException("Missing 'var' to store the queue.");
            }
            this.varAccess = SessionFactory.access(this.var);
            this.key = new Queue.Key();
            Locator locator = Locator.current();
            if (this.sequence != null && this.sequenceBuilder != null) {
                throw new BenchmarkDefinitionException("Cannot set sequence using both name and builder.");
            }
            if (this.sequence == null && this.sequenceBuilder == null) {
                throw new BenchmarkDefinitionException("No sequence was set!");
            }
            if (this.sequenceBuilder == null) {
                SequenceBuilder originalSequence = locator.scenario().findSequence(this.sequence);
                String generatedSeqName = String.format("%s_queue_%08x", this.sequence, ThreadLocalRandom.current().nextInt());
                this.sequenceBuilder = locator.scenario().sequence(generatedSeqName);
                this.sequenceBuilder.readFrom(originalSequence);
            }
            Queue.Key myKey = this.key;
            if (this.sequenceCompletion == null) {
                this.sequenceBuilder.step(s -> {
                    s.getResource(myKey).consumed(s);
                    return true;
                });
            } else {
                this.sequenceCompletion.accept(() -> s -> s.getResource(myKey).consumed(s));
            }
            this.sequenceBuilder.concurrency(this.concurrency);
            this.sequenceBuilder.prepareBuild();
        }

        @Override
        public Processor build(boolean fragmented) {
            if (this.maxSize <= 0) {
                throw new BenchmarkDefinitionException("Maximum size for queue to " + this.var + " must be set!");
            }
            Action completionAction = this.onCompletion == null ? null : this.onCompletion.build();
            QueueProcessor processor = new QueueProcessor(this.key, this.varAccess, this.maxSize, this.format, this.sequenceBuilder.name(), this.concurrency, completionAction);
            return fragmented ? new DefragProcessor(processor) : processor;
        }
    }
}

