/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RequestProcessorBuilder;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class StoreProcessor
implements Processor,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(StoreProcessor.class);
    private final Access toVar;
    private final DataFormat format;

    public StoreProcessor(Access toVar, DataFormat format) {
        this.toVar = toVar;
        this.format = format;
    }

    @Override
    public void before(Session session) {
        this.toVar.unset(session);
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        this.ensureDefragmented(isLastPart);
        if (this.toVar.isSet(session)) {
            log.warn((Object)"Variable {} was already set, not setting again.", new Object[]{this.toVar});
        } else {
            Object value = this.format.convert(data, offset, length);
            this.toVar.setObject(session, value);
        }
    }

    @Override
    public void reserve(Session session) {
        this.toVar.declareObject(session);
    }

    @Name(value="simple")
    public static class LegacyBuilder
    extends Builder {
    }

    @Name(value="store")
    public static class Builder
    implements RequestProcessorBuilder,
    InitFromParam<Builder> {
        private Object toVar;
        private DataFormat format = DataFormat.STRING;

        @Override
        public Builder init(String param) {
            this.toVar = param;
            return this;
        }

        public Builder toVar(Object toVar) {
            this.toVar = toVar;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }

        @Override
        public Processor build(boolean fragmented) {
            StoreProcessor storeProcessor = new StoreProcessor(SessionFactory.access(this.toVar), this.format);
            return fragmented ? new DefragProcessor(storeProcessor) : storeProcessor;
        }
    }
}

