/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RequestProcessorBuilder;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.handlers.json.ByteStream;
import io.hyperfoil.core.handlers.json.JsonParser;
import io.hyperfoil.core.handlers.json.JsonUnquotingTransformer;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.Function;

public class JsonHandler
extends JsonParser
implements Processor,
Session.ResourceKey<Context> {
    public JsonHandler(String query, boolean delete, Transformer replace, Processor processor) {
        super(query.trim(), delete, replace, processor);
    }

    @Override
    public void before(Session session) {
        this.processor.before(session);
        if (this.replace != null) {
            this.replace.before(session);
        }
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLast) {
        Context ctx = session.getResource(this);
        ctx.parse(ctx.wrap(data, offset, length), session, isLast);
    }

    @Override
    public void after(Session session) {
        if (this.replace != null) {
            this.replace.after(session);
        }
        this.processor.after(session);
        Context ctx = session.getResource(this);
        ctx.reset();
    }

    public String toString() {
        return "JsonHandler{query='" + this.query + "', recorder=" + this.processor + "}";
    }

    @Override
    public void reserve(Session session) {
        super.reserve(session);
        session.declareResource(this, () -> new Context());
    }

    @Override
    protected void record(JsonParser.Context context, Session session, ByteStream data, int offset, int length, boolean isLastPart) {
        this.processor.process(session, ((ByteBufByteStream)data).buffer, offset, length, isLastPart);
    }

    static class ByteBufByteStream
    implements ByteStream {
        private final Function<ByteStream, ByteStream> retain;
        private final Consumer<ByteStream> release;
        private ByteBuf buffer;
        private int readerIndex;

        ByteBufByteStream(Function<ByteStream, ByteStream> retain, Consumer<ByteStream> release) {
            this.retain = retain;
            this.release = release;
        }

        @Override
        public boolean isReadable() {
            return this.readerIndex < this.buffer.writerIndex();
        }

        @Override
        public byte readByte() {
            assert (this.isReadable());
            return this.buffer.getByte(this.readerIndex++);
        }

        @Override
        public int getByte(int index) {
            return this.buffer.getByte(index);
        }

        @Override
        public int writerIndex() {
            return this.buffer.writerIndex();
        }

        @Override
        public int readerIndex() {
            return this.readerIndex;
        }

        @Override
        public void release() {
            this.buffer.release();
            this.buffer = null;
            this.readerIndex = -1;
            this.release.accept(this);
        }

        @Override
        public ByteStream retain() {
            this.buffer.retain();
            return this.retain.apply(this);
        }

        @Override
        public void moveTo(ByteStream other) {
            ByteBufByteStream o = (ByteBufByteStream)other;
            assert (o.buffer == null);
            o.buffer = this.buffer;
            o.readerIndex = this.readerIndex;
            this.buffer = null;
            this.readerIndex = -1;
        }
    }

    @Name(value="json")
    public static class Builder
    extends JsonParser.BaseBuilder<Builder>
    implements RequestProcessorBuilder {
        @Override
        public JsonHandler build(boolean fragmented) {
            Transformer replace;
            Processor processor = this.processor.build(fragmented);
            Transformer transformer = replace = this.replace == null ? null : this.replace.build(fragmented);
            if (this.unquote) {
                processor = new JsonUnquotingTransformer(processor);
                if (replace != null) {
                    replace = new JsonUnquotingTransformer(replace);
                }
            }
            return new JsonHandler(this.query, this.delete, replace, processor);
        }

        public ServiceLoadedBuilderProvider<RequestProcessorBuilder> processor() {
            return new ServiceLoadedBuilderProvider<RequestProcessorBuilder>(RequestProcessorBuilder.class, this::processor);
        }
    }

    public class Context
    extends JsonParser.Context {
        ByteBufByteStream actualStream;

        Context() {
            super(self -> new ByteBufByteStream(null, self::release));
            this.actualStream = new ByteBufByteStream(this::retain, null);
        }

        public ByteStream wrap(ByteBuf data, int offset, int length) {
            this.actualStream.buffer = data;
            this.actualStream.readerIndex = offset;
            return this.actualStream;
        }

        @Override
        protected void replaceConsumer(Void ignored, Session session, ByteStream data, int offset, int length, boolean lastFragment) {
            JsonHandler.this.replace.transform(session, ((ByteBufByteStream)data).buffer, offset, length, lastFragment, this.replaceBuffer);
        }
    }
}

