/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.handlers.ArrayRecorder;
import io.hyperfoil.core.handlers.StoreProcessor;
import io.hyperfoil.core.handlers.json.ByteStream;
import io.hyperfoil.core.handlers.json.StreamQueue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public abstract class JsonParser
implements Serializable,
ResourceUtilizer {
    protected static final Logger log = LoggerFactory.getLogger(JsonParser.class);
    protected static final int MAX_PARTS = 16;
    protected final String query;
    protected final boolean delete;
    protected final Transformer replace;
    protected final Processor processor;
    @Visitor.Ignore
    private final Selector[] selectors;
    @Visitor.Ignore
    private final StreamQueue.Consumer<Context, Session> record = this::record;

    public JsonParser(String query, boolean delete, Transformer replace, Processor processor) {
        this.query = query;
        this.delete = delete;
        this.replace = replace;
        this.processor = processor;
        byte[] queryBytes = query.getBytes(StandardCharsets.UTF_8);
        if (queryBytes.length == 0 || queryBytes[0] != 46) {
            throw new BenchmarkDefinitionException("Path should start with '.'");
        }
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        int next = 1;
        block0: for (int i = 1; i < queryBytes.length; ++i) {
            if (queryBytes[i] == 91 || queryBytes[i] == 46 && next < i) {
                while (queryBytes[next] == 46) {
                    ++next;
                }
                if (next != i) {
                    selectors.add(new AttribSelector(Arrays.copyOfRange(queryBytes, next, i)));
                }
                next = i + 1;
            }
            if (queryBytes[i] != 91) continue;
            ArraySelector arraySelector = new ArraySelector();
            int startIndex = ++i;
            int endIndex = i;
            while (i < queryBytes.length) {
                if (queryBytes[i] == 93) {
                    if (endIndex < i) {
                        arraySelector.rangeEnd = JsonParser.bytesToInt(queryBytes, startIndex, i);
                        if (startIndex == endIndex) {
                            arraySelector.rangeStart = arraySelector.rangeEnd;
                        }
                    }
                    selectors.add(arraySelector);
                    next = i + 1;
                    continue block0;
                }
                if (queryBytes[i] == 58) {
                    if (startIndex < i) {
                        arraySelector.rangeStart = JsonParser.bytesToInt(queryBytes, startIndex, i);
                    }
                    endIndex = i + 1;
                }
                ++i;
            }
        }
        if (next < queryBytes.length) {
            while (queryBytes[next] == 46) {
                ++next;
            }
            selectors.add(new AttribSelector(Arrays.copyOfRange(queryBytes, next, queryBytes.length)));
        }
        this.selectors = selectors.toArray(new Selector[0]);
    }

    protected abstract void record(Context var1, Session var2, ByteStream var3, int var4, int var5, boolean var6);

    private static int bytesToInt(byte[] bytes, int start, int end) {
        int value = 0;
        while (true) {
            if (bytes[start] < 48 || bytes[start] > 57) {
                throw new BenchmarkDefinitionException("Invalid range specification: " + new String(bytes));
            }
            value += bytes[start] - 48;
            if (++start >= end) {
                return value;
            }
            value *= 10;
        }
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.processor, this.replace);
    }

    public static abstract class BaseBuilder<S extends BaseBuilder<S>>
    implements InitFromParam<S> {
        protected String query;
        protected boolean unquote = true;
        protected Processor.Builder<?> processor;
        protected DataFormat format = DataFormat.STRING;
        protected boolean delete;
        protected Transformer.Builder replace;

        @Override
        public S init(String param) {
            String var;
            String query;
            if (param.contains("->")) {
                String[] parts = param.split("->");
                query = parts[0];
                var = parts[1];
            } else if (param.contains("<-")) {
                String[] parts = param.split("->");
                query = parts[1];
                var = parts[0];
            } else {
                throw new BenchmarkDefinitionException("Cannot parse json query specification: '" + param + "', use 'query -> var' or 'var <- query'");
            }
            return ((BaseBuilder)this.query(query.trim())).toVar(var.trim());
        }

        protected S self() {
            return (S)this;
        }

        public S query(String query) {
            this.query = query;
            return this.self();
        }

        public S unquote(boolean unquote) {
            this.unquote = unquote;
            return this.self();
        }

        public S delete(boolean delete) {
            this.delete = delete;
            return this.self();
        }

        public ServiceLoadedBuilderProvider<Transformer.Builder> replace() {
            return new ServiceLoadedBuilderProvider<Transformer.Builder>(Transformer.Builder.class, this::replace);
        }

        public S replace(Transformer.Builder replace) {
            if (this.replace != null) {
                throw new BenchmarkDefinitionException("Calling replace twice!");
            }
            this.replace = replace;
            return this.self();
        }

        public S replace(String pattern) {
            return ((BaseBuilder)this.replace((boolean fragmented) -> new Pattern(pattern, false))).unquote(false);
        }

        public S toArray(String varAndSize) {
            return this.processor(new ArrayRecorder.Builder().init(varAndSize).format(this.format));
        }

        public S toVar(String var) {
            return this.processor(new StoreProcessor.Builder().toVar(var).format(this.format));
        }

        public S processor(Processor.Builder<?> processor) {
            if (this.processor != null) {
                throw new BenchmarkDefinitionException("Processor already set!");
            }
            this.processor = processor;
            return this.self();
        }

        public S format(DataFormat format) {
            this.format = format;
            return this.self();
        }

        protected void validate() {
            if (this.query == null) {
                throw new BenchmarkDefinitionException("Missing 'query'");
            }
            if (this.processor == null) {
                throw new BenchmarkDefinitionException("Missing processor - use 'processor', 'toVar' or 'toArray'");
            }
        }
    }

    protected abstract class Context
    implements Session.Resource {
        Selector.Context[] selectorContext;
        int level;
        int selectorLevel;
        int selector;
        boolean inQuote;
        boolean inKey;
        boolean escaped;
        StreamQueue stream;
        int keyStartIndex;
        int lastCharIndex;
        int valueStartIndex;
        int lastOutputIndex;
        int safeOutputIndex;
        ByteStream[] pool;
        protected ByteBuf replaceBuffer;
        final StreamQueue.Consumer<Void, Session> replaceConsumer;

        protected Context(Function<Context, ByteStream> byteStreamSupplier) {
            int i;
            this.selectorContext = new Selector.Context[JsonParser.this.selectors.length];
            this.stream = new StreamQueue(16);
            this.pool = new ByteStream[16];
            this.replaceBuffer = PooledByteBufAllocator.DEFAULT.buffer();
            this.replaceConsumer = this::replaceConsumer;
            for (i = 0; i < this.pool.length; ++i) {
                this.pool[i] = byteStreamSupplier.apply(this);
            }
            for (i = 0; i < JsonParser.this.selectors.length; ++i) {
                this.selectorContext[i] = JsonParser.this.selectors[i].newContext();
            }
            this.reset();
        }

        public void reset() {
            for (Selector.Context ctx : this.selectorContext) {
                if (ctx == null) continue;
                ctx.reset();
            }
            this.level = -1;
            this.selectorLevel = 0;
            this.selector = 0;
            this.inQuote = false;
            this.inKey = false;
            this.escaped = false;
            this.keyStartIndex = -1;
            this.lastCharIndex = -1;
            this.valueStartIndex = -1;
            this.lastOutputIndex = 0;
            this.safeOutputIndex = 0;
            this.stream.reset();
            this.replaceBuffer.clear();
        }

        private Selector.Context current() {
            return this.selectorContext[this.selector];
        }

        public void parse(ByteStream data, Session session, boolean isLast) {
            int readerIndex = this.stream.append(data);
            block15: while (true) {
                int b = this.stream.getByte(readerIndex++);
                switch (b) {
                    case -1: {
                        --readerIndex;
                        break block15;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 92: {
                        this.escaped = !this.escaped;
                        break;
                    }
                    case 123: {
                        if (this.inQuote) break;
                        ++this.level;
                        this.inKey = true;
                        if (this.valueStartIndex >= 0) break;
                        this.safeOutputIndex = readerIndex;
                        break;
                    }
                    case 125: {
                        if (this.inQuote) break;
                        this.tryRecord(session, readerIndex);
                        if (this.level == this.selectorLevel) {
                            --this.selectorLevel;
                            --this.selector;
                        }
                        if (this.valueStartIndex < 0) {
                            this.safeOutputIndex = readerIndex;
                        }
                        --this.level;
                        break;
                    }
                    case 34: {
                        if (this.escaped) break;
                        this.inQuote = !this.inQuote;
                        break;
                    }
                    case 58: {
                        AttribSelector selector;
                        if (this.inQuote) break;
                        if (this.selectorLevel == this.level && this.keyStartIndex >= 0 && this.selector < JsonParser.this.selectors.length && JsonParser.this.selectors[this.selector] instanceof AttribSelector && (selector = (AttribSelector)JsonParser.this.selectors[this.selector]).match(this.stream, this.keyStartIndex, this.lastCharIndex) && this.onMatch(readerIndex) && (JsonParser.this.delete || JsonParser.this.replace != null)) {
                            int outputEnd = this.keyStartIndex - 1;
                            block16: while (true) {
                                switch (this.stream.getByte(outputEnd - 1)) {
                                    case 9: 
                                    case 10: 
                                    case 13: 
                                    case 32: 
                                    case 44: {
                                        --outputEnd;
                                        continue block16;
                                    }
                                }
                                break;
                            }
                            this.stream.consume(this.lastOutputIndex, outputEnd, JsonParser.this.record, this, session, false);
                            this.lastOutputIndex = outputEnd;
                        }
                        this.keyStartIndex = -1;
                        if (this.valueStartIndex < 0) {
                            this.safeOutputIndex = readerIndex;
                        }
                        this.inKey = false;
                        break;
                    }
                    case 44: {
                        if (this.inQuote) break;
                        this.inKey = true;
                        this.keyStartIndex = -1;
                        this.tryRecord(session, readerIndex);
                        if (this.selectorLevel != this.level || this.selector >= JsonParser.this.selectors.length || !(this.current() instanceof ArraySelectorContext)) break;
                        ArraySelectorContext asc = (ArraySelectorContext)this.current();
                        if (asc.active) {
                            ++asc.currentItem;
                        }
                        if (!((ArraySelector)JsonParser.this.selectors[this.selector]).matches(asc) || !this.onMatch(readerIndex) || !JsonParser.this.delete && JsonParser.this.replace == null) break;
                        this.stream.consume(this.lastOutputIndex, readerIndex - 1, JsonParser.this.record, this, session, false);
                        this.lastOutputIndex = readerIndex - 1;
                        break;
                    }
                    case 91: {
                        if (this.inQuote) break;
                        if (this.valueStartIndex < 0) {
                            this.safeOutputIndex = readerIndex;
                        }
                        ++this.level;
                        if (this.selectorLevel != this.level || this.selector >= JsonParser.this.selectors.length || !(JsonParser.this.selectors[this.selector] instanceof ArraySelector)) break;
                        ArraySelectorContext asc = (ArraySelectorContext)this.current();
                        asc.active = true;
                        if (!((ArraySelector)JsonParser.this.selectors[this.selector]).matches(asc) || !this.onMatch(readerIndex) || !JsonParser.this.delete && JsonParser.this.replace == null) break;
                        this.stream.consume(this.lastOutputIndex, readerIndex, JsonParser.this.record, this, session, false);
                        this.lastOutputIndex = readerIndex;
                        break;
                    }
                    case 93: {
                        ArraySelectorContext asc;
                        if (this.inQuote) break;
                        this.tryRecord(session, readerIndex);
                        if (this.selectorLevel == this.level && this.selector < JsonParser.this.selectors.length && this.current() instanceof ArraySelectorContext) {
                            asc = (ArraySelectorContext)this.current();
                            asc.active = false;
                            --this.selectorLevel;
                        }
                        if (this.valueStartIndex < 0) {
                            this.safeOutputIndex = readerIndex;
                        }
                        --this.level;
                        break;
                    }
                    default: {
                        this.lastCharIndex = readerIndex;
                        if (!this.inKey || this.keyStartIndex >= 0) break;
                        this.keyStartIndex = readerIndex - 1;
                    }
                }
                if (b == 92) continue;
                this.escaped = false;
            }
            if (this.keyStartIndex >= 0 || this.valueStartIndex >= 0) {
                this.stream.release(Math.min(Math.min(this.keyStartIndex, this.valueStartIndex), this.safeOutputIndex));
                if (isLast) {
                    throw new IllegalStateException("End of input while the JSON is not complete.");
                }
            } else {
                if ((JsonParser.this.delete || JsonParser.this.replace != null) && this.lastOutputIndex < this.safeOutputIndex) {
                    this.stream.consume(this.lastOutputIndex, this.safeOutputIndex, JsonParser.this.record, this, session, isLast);
                    this.lastOutputIndex = this.safeOutputIndex;
                }
                this.stream.release(readerIndex);
            }
        }

        private boolean onMatch(int readerIndex) {
            ++this.selector;
            if (this.selector < JsonParser.this.selectors.length) {
                ++this.selectorLevel;
                return false;
            }
            this.valueStartIndex = readerIndex;
            return true;
        }

        private void tryRecord(Session session, int readerIndex) {
            if (this.selectorLevel == this.level && this.valueStartIndex >= 0) {
                int end;
                block6: while (true) {
                    switch (this.stream.getByte(this.valueStartIndex)) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            ++this.valueStartIndex;
                            continue block6;
                        }
                    }
                    break;
                }
                block7: for (end = readerIndex - 1; end > this.valueStartIndex; --end) {
                    switch (this.stream.getByte(end - 1)) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block7;
                        }
                    }
                }
                if (this.valueStartIndex == end) {
                    this.valueStartIndex = -1;
                    --this.selector;
                    return;
                }
                if (JsonParser.this.replace != null) {
                    this.replaceBuffer.readerIndex(this.replaceBuffer.writerIndex());
                    this.stream.consume(this.valueStartIndex, end, this.replaceConsumer, null, session, true);
                    if (this.replaceBuffer.isReadable()) {
                        this.stream.consume(this.lastOutputIndex, this.valueStartIndex, JsonParser.this.record, this, session, false);
                        JsonParser.this.processor.process(session, this.replaceBuffer, this.replaceBuffer.readerIndex(), this.replaceBuffer.readableBytes(), false);
                    }
                } else if (!JsonParser.this.delete) {
                    this.stream.consume(this.valueStartIndex, end, JsonParser.this.record, this, session, true);
                }
                this.lastOutputIndex = end;
                this.valueStartIndex = -1;
                --this.selector;
            }
        }

        public ByteStream retain(ByteStream stream) {
            for (int i = 0; i < this.pool.length; ++i) {
                ByteStream pooled = this.pool[i];
                if (pooled == null) continue;
                this.pool[i] = null;
                stream.moveTo(pooled);
                return pooled;
            }
            throw new IllegalStateException();
        }

        public void release(ByteStream stream) {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != null) continue;
                this.pool[i] = stream;
                return;
            }
            throw new IllegalStateException();
        }

        protected abstract void replaceConsumer(Void var1, Session var2, ByteStream var3, int var4, int var5, boolean var6);
    }

    private static class ArraySelectorContext
    implements Selector.Context {
        boolean active;
        int currentItem;

        private ArraySelectorContext() {
        }

        @Override
        public void reset() {
            this.active = false;
            this.currentItem = 0;
        }
    }

    private static class ArraySelector
    implements Selector {
        int rangeStart = 0;
        int rangeEnd = Integer.MAX_VALUE;

        private ArraySelector() {
        }

        @Override
        public Selector.Context newContext() {
            return new ArraySelectorContext();
        }

        boolean matches(ArraySelectorContext context) {
            return context.active && context.currentItem >= this.rangeStart && context.currentItem <= this.rangeEnd;
        }
    }

    private static class AttribSelector
    implements Selector {
        byte[] name;

        AttribSelector(byte[] name) {
            this.name = name;
        }

        boolean match(StreamQueue stream, int start, int end) {
            assert (start <= end);
            for (int i = 0; i < this.name.length && i < end - start; ++i) {
                if (this.name[i] == stream.getByte(start + i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Selector.Context newContext() {
            return null;
        }
    }

    static interface Selector
    extends Serializable {
        public Context newContext();

        public static interface Context {
            public void reset();
        }
    }
}

