/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.core.handlers.json.ByteStream;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Arrays;

public class StreamQueue {
    protected static final Logger log = LoggerFactory.getLogger(StreamQueue.class);
    private final ByteStream[] parts;
    private final int[] userIndex;
    private final int mask;
    private int end = -1;
    private int tail = 0;
    private int length = 0;

    public StreamQueue(int capacity) {
        this.mask = (1 << 32 - Integer.numberOfLeadingZeros(capacity - 1)) - 1;
        this.parts = new ByteStream[capacity];
        this.userIndex = new int[capacity];
        Arrays.fill(this.userIndex, -1);
    }

    public int append(ByteStream stream) {
        ByteStream retained;
        if (this.parts[this.tail] != null) {
            log.warn((Object)"Too many buffered fragments, dropping data.");
            this.parts[this.tail].release();
        }
        this.parts[this.tail] = retained = stream.retain();
        this.userIndex[this.tail] = this.length;
        this.length += retained.writerIndex() - retained.readerIndex();
        this.end = this.tail;
        this.tail = this.tail + 1 & this.mask;
        return this.userIndex[this.end];
    }

    public void release(int index) {
        int i = this.end;
        while (index < this.userIndex[i]) {
            if ((i = i + this.mask & this.mask) != this.end && this.parts[i] != null) continue;
            return;
        }
        if ((i = i + this.mask & this.mask) == this.end || this.parts[i] == null) {
            return;
        }
        while (i != this.end && this.parts[i] != null) {
            this.userIndex[i] = -1;
            this.parts[i].release();
            this.parts[i] = null;
            i = i + this.mask & this.mask;
        }
    }

    public int getByte(int index) {
        int i = this.end;
        while (index < this.userIndex[i]) {
            if ((i = i + this.mask & this.mask) != this.end && this.parts[i] != null) continue;
            return -1;
        }
        ByteStream part = this.parts[i];
        int partIndex = index - this.userIndex[i];
        if (part.readerIndex() + partIndex >= part.writerIndex()) {
            return -1;
        }
        return part.getByte(part.readerIndex() + partIndex);
    }

    public void reset() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] != null) {
                this.parts[i].release();
                this.parts[i] = null;
            }
            this.userIndex[i] = -1;
        }
        this.length = 0;
        this.end = -1;
    }

    public <P1, P2> void consume(int startIndex, int endIndex, Consumer<P1, P2> consumer, P1 p1, P2 p2, boolean isComplete) {
        int i = this.end;
        while (startIndex < this.userIndex[i]) {
            if ((i = i + this.mask & this.mask) != this.end && this.parts[i] != null) continue;
            ++i;
            break;
        }
        int partIndex = startIndex - this.userIndex[i];
        boolean isLast = false;
        while (!isLast) {
            int length;
            ByteStream part = this.parts[i];
            int end = part.writerIndex();
            if (endIndex <= this.userIndex[i] + part.writerIndex() - part.readerIndex()) {
                end = endIndex - this.userIndex[i] + part.readerIndex();
                isLast = true;
            }
            if ((length = end - partIndex - part.readerIndex()) > 0) {
                consumer.accept(p1, p2, part, part.readerIndex() + partIndex, length, isComplete && isLast);
            }
            partIndex = 0;
            i = i + 1 & this.mask;
        }
    }

    public static interface Consumer<P1, P2>
    extends Serializable {
        public void accept(P1 var1, P2 var2, ByteStream var3, int var4, int var5, boolean var6);
    }
}

