/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.hooks;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.RunHook;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.function.Consumer;

public class ExecRunHook
extends RunHook {
    private static final Logger log = LoggerFactory.getLogger(ExecRunHook.class);
    private final String command;

    public ExecRunHook(String name, String command) {
        super(name);
        this.command = command;
    }

    @Override
    public boolean run(Map<String, String> properties, Consumer<String> outputConsumer) {
        ProcessBuilder pb = new ProcessBuilder("sh", "-c", this.command).inheritIO().redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.environment().putAll(properties);
        try {
            log.info((Object)"{}: Starting command {}", new Object[]{this.name, this.command});
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.trace((Object)line);
                    outputConsumer.accept(line);
                    outputConsumer.accept("\n");
                }
            }
            int exitValue = process.waitFor();
            log.info((Object)"{}: Completed command with exit code {}", new Object[]{this.name, exitValue});
            return exitValue == 0;
        }
        catch (IOException e) {
            log.error((Object)"Cannot start {}", (Throwable)e, new Object[]{this.name});
            return false;
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted during hook execution", (Throwable)e);
            return false;
        }
    }

    @Name(value="exec")
    public static class Builder
    implements RunHook.Builder,
    InitFromParam<Builder> {
        private String cmd;

        @Override
        public Builder init(String param) {
            this.cmd = param;
            return this;
        }

        @Override
        public RunHook build(String name) {
            return new ExecRunHook(name, this.cmd);
        }
    }
}

