/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.http;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GzipInflatorProcessor
extends MultiProcessor
implements Session.ResourceKey<InflaterResource> {
    private static final Logger log = LoggerFactory.getLogger(GzipInflatorProcessor.class);
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private final Access encodingVar;

    public GzipInflatorProcessor(Processor[] processors, Access encodingVar) {
        super(processors);
        this.encodingVar = encodingVar;
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Session.Var var = this.encodingVar.getVar(session);
        InflaterResource resource = session.getResource(this);
        switch (resource.state) {
            case NOT_ENCRYPTED: {
                super.process(session, data, offset, length, isLastPart);
            }
            case INVALID: {
                return;
            }
            case UNINITIALIZED: {
                if (var.isSet() && "gzip".equalsIgnoreCase(var.objectValue(session).toString())) {
                    resource.state = State.FIRST_4_BYTES;
                    resource.inflater.reset();
                    break;
                }
                resource.state = State.NOT_ENCRYPTED;
                return;
            }
        }
        resource.process(session, data, offset, length);
    }

    @Override
    public void reserve(Session session) {
        super.reserve(session);
        session.declareResource(this, () -> new InflaterResource());
    }

    @Name(value="gzipInflator")
    public static class Builder
    implements HttpRequestProcessorBuilder {
        public final List<Processor.Builder<?>> delegates = new ArrayList();
        private Object encodingVar;

        @Override
        public Processor build(boolean fragmented) {
            Processor[] processors = (Processor[])this.delegates.stream().map(d -> d.build(true)).toArray(Processor[]::new);
            return new GzipInflatorProcessor(processors, SessionFactory.access(this.encodingVar));
        }

        public Builder processor(Processor.Builder<?> processor) {
            this.delegates.add(processor);
            return this;
        }

        public Builder processors(Collection<? extends Processor.Builder<?>> processors) {
            this.delegates.addAll(processors);
            return this;
        }

        public ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder> processor() {
            return new ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder>(HttpRequestProcessorBuilder.class, this.delegates::add);
        }

        public Builder encodingVar(Object var) {
            this.encodingVar = var;
            return this;
        }
    }

    private static enum State {
        UNINITIALIZED,
        NOT_ENCRYPTED,
        INVALID,
        FIRST_4_BYTES,
        SKIP_6_BYTES,
        CHECK_EXTRA_FIELDS,
        SKIP_EXTRA_FIELDS,
        SKIP_FILENAME,
        SKIP_COMMENT,
        CHECK_HEADER_CRC,
        DATA,
        EOF;

    }

    public class InflaterResource
    implements Session.Resource {
        private final Inflater inflater = new Inflater(true);
        private State state = State.UNINITIALIZED;
        private final byte[] buf = new byte[512];
        private int bufSize = 0;
        private final ByteBuf output = ByteBufAllocator.DEFAULT.buffer(512);
        private final ByteBuffer nioOutput;

        private InflaterResource() {
            this.output.writerIndex(this.output.capacity());
            assert (this.output.nioBufferCount() == 1);
            this.nioOutput = this.output.nioBuffer();
        }

        public void process(Session session, ByteBuf data, int offset, int length) {
            block14: while (length > 0) {
                switch (this.state) {
                    case INVALID: {
                        return;
                    }
                    case FIRST_4_BYTES: {
                        int read = Math.min(length, 4 - this.bufSize);
                        data.getBytes(offset, this.buf, this.bufSize, read);
                        this.bufSize += read;
                        length -= read;
                        offset += read;
                        if (this.bufSize < 4) continue block14;
                        if (Byte.toUnsignedInt(this.buf[0]) != 31 || Byte.toUnsignedInt(this.buf[1]) != 139) {
                            log.error((Object)"#{} Invalid magic bytes at the beginning of the stream", new Object[]{session.uniqueId()});
                            this.invalidate(session);
                            continue block14;
                        }
                        if (Byte.toUnsignedInt(this.buf[2]) != 8) {
                            log.error((Object)"#{} Invalid compression method", new Object[]{session.uniqueId()});
                            this.invalidate(session);
                            continue block14;
                        }
                        this.state = State.SKIP_6_BYTES;
                        this.bufSize = 0;
                        continue block14;
                    }
                    case SKIP_6_BYTES: {
                        int read = Math.min(length, 6 - this.bufSize);
                        this.bufSize += read;
                        offset += read;
                        length -= read;
                        if (this.bufSize < 6) continue block14;
                        this.state = State.CHECK_EXTRA_FIELDS;
                        this.bufSize = 0;
                        continue block14;
                    }
                    case CHECK_EXTRA_FIELDS: {
                        int read;
                        if ((Byte.toUnsignedInt(this.buf[3]) & 4) != 0) {
                            read = Math.min(length, 2 - this.bufSize);
                            data.getBytes(offset, this.buf, 0, read);
                            this.bufSize += read;
                            offset += read;
                            length -= read;
                            if (this.bufSize < 2) continue block14;
                            this.state = State.SKIP_EXTRA_FIELDS;
                            this.bufSize = Byte.toUnsignedInt(this.buf[1]) << 8 | Byte.toUnsignedInt(this.buf[0]);
                            continue block14;
                        }
                        this.state = State.SKIP_FILENAME;
                        continue block14;
                    }
                    case SKIP_EXTRA_FIELDS: {
                        int read = Math.min(length, this.bufSize);
                        offset += read;
                        length -= read;
                        this.bufSize -= read;
                        if (this.bufSize != 0) continue block14;
                        this.state = State.SKIP_FILENAME;
                        continue block14;
                    }
                    case SKIP_FILENAME: {
                        if ((Byte.toUnsignedInt(this.buf[3]) & 8) != 0) {
                            if (!this.skipZeroTerminated(data, offset, length)) continue block14;
                            this.state = State.SKIP_COMMENT;
                            continue block14;
                        }
                        this.state = State.SKIP_COMMENT;
                        continue block14;
                    }
                    case SKIP_COMMENT: {
                        if ((Byte.toUnsignedInt(this.buf[3]) & 0x10) != 0) {
                            if (!this.skipZeroTerminated(data, offset, length)) continue block14;
                            this.state = State.CHECK_HEADER_CRC;
                            continue block14;
                        }
                        this.state = State.CHECK_HEADER_CRC;
                        continue block14;
                    }
                    case CHECK_HEADER_CRC: {
                        int read;
                        if ((Byte.toUnsignedInt(this.buf[3]) & 2) != 0) {
                            read = Math.min(length, 2 - this.bufSize);
                            this.bufSize += read;
                            offset += read;
                            length -= read;
                            if (this.bufSize < 2) continue block14;
                            this.state = State.DATA;
                            continue block14;
                        }
                        this.state = State.DATA;
                        continue block14;
                    }
                    case DATA: {
                        int read;
                        try {
                            int n;
                            while ((n = this.inflater.inflate(this.nioOutput)) == 0) {
                                if (this.inflater.needsDictionary()) {
                                    log.error((Object)"#{} decompression requires a pre-set dictionary but it is not available.", new Object[]{session.uniqueId()});
                                    this.invalidate(session);
                                    break;
                                }
                                if (this.inflater.finished()) {
                                    offset -= this.inflater.getRemaining();
                                    length += this.inflater.getRemaining();
                                    this.inflater.reset();
                                    GzipInflatorProcessor.super.process(session, Unpooled.EMPTY_BUFFER, 0, 0, true);
                                    this.state = State.EOF;
                                    this.bufSize = 8;
                                    break;
                                }
                                if (!this.inflater.needsInput()) continue;
                                if (length == 0) break;
                                read = Math.min(this.buf.length, length);
                                data.getBytes(offset, this.buf, 0, read);
                                offset += read;
                                length -= read;
                                this.inflater.setInput(this.buf, 0, read);
                            }
                            if (n == 0) continue block14;
                            this.nioOutput.position(0).limit(this.output.capacity());
                            boolean finished = this.inflater.finished();
                            GzipInflatorProcessor.super.process(session, this.output, 0, n, finished);
                            if (!finished) continue block14;
                            offset -= this.inflater.getRemaining();
                            length += this.inflater.getRemaining();
                            this.inflater.reset();
                            this.state = State.EOF;
                            this.bufSize = 8;
                        }
                        catch (DataFormatException e) {
                            log.error((Object)"#{} Failed to decompress GZIPed data.", (Throwable)e, new Object[]{session.uniqueId()});
                            this.invalidate(session);
                        }
                        continue block14;
                    }
                    case EOF: {
                        int read = Math.min(length, this.bufSize);
                        offset += read;
                        length -= read;
                        this.bufSize -= read;
                        if (this.bufSize != 0) continue block14;
                        this.state = State.FIRST_4_BYTES;
                        continue block14;
                    }
                }
                throw new IllegalStateException(this.state.toString());
            }
        }

        private void invalidate(Session session) {
            Request request = session.currentRequest();
            if (request != null) {
                request.markInvalid();
            }
            this.state = State.INVALID;
        }

        private boolean skipZeroTerminated(ByteBuf data, int offset, int length) {
            byte b;
            do {
                b = data.getByte(offset);
                ++offset;
            } while (b != 0 && --length > 0);
            return b == 0;
        }
    }
}

