/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.collection.ElasticPool;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class ElasticPoolImpl<T>
implements ElasticPool<T> {
    private final Supplier<T> initSupplier;
    private final Supplier<T> depletionSupplier;
    private ArrayBlockingQueue<T> primaryQueue;
    private final BlockingQueue<T> secondaryQueue = new LinkedBlockingQueue<T>();
    private final LongAdder used = new LongAdder();
    private volatile int minUsed = Integer.MAX_VALUE;
    private volatile int maxUsed;

    public ElasticPoolImpl(Supplier<T> initSupplier, Supplier<T> depletionSupplier) {
        this.initSupplier = initSupplier;
        this.depletionSupplier = depletionSupplier;
    }

    @Override
    public T acquire() {
        Object object = this.primaryQueue.poll();
        if (object != null) {
            this.incrementUsed();
            return object;
        }
        object = this.secondaryQueue.poll();
        if (object != null) {
            this.incrementUsed();
            return object;
        }
        object = this.depletionSupplier.get();
        if (object != null) {
            this.incrementUsed();
        }
        return object;
    }

    private void incrementUsed() {
        this.used.increment();
        long currentlyUsed = this.used.longValue();
        if (currentlyUsed > (long)this.maxUsed) {
            this.maxUsed = (int)currentlyUsed;
        }
    }

    @Override
    public void release(T object) {
        this.used.decrement();
        long currentlyUsed = this.used.longValue();
        if (currentlyUsed < (long)this.minUsed) {
            this.minUsed = (int)currentlyUsed;
        }
        if (this.primaryQueue.offer(object)) {
            return;
        }
        this.secondaryQueue.add(object);
    }

    @Override
    public void reserve(int capacity) {
        if (this.primaryQueue == null || this.primaryQueue.size() < capacity) {
            this.primaryQueue = new ArrayBlockingQueue(capacity);
        }
        while (this.primaryQueue.size() < capacity) {
            this.primaryQueue.add(this.initSupplier.get());
        }
    }

    @Override
    public int minUsed() {
        return this.minUsed;
    }

    @Override
    public int maxUsed() {
        return this.maxUsed;
    }

    @Override
    public void resetStats() {
        int current;
        this.minUsed = current = this.used.intValue();
        this.maxUsed = current;
    }
}

