/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class LocalBenchmarkData
implements BenchmarkData {
    private static final Logger log = LoggerFactory.getLogger(LocalBenchmarkData.class);
    private final Path benchmarkPath;
    private final Map<String, byte[]> readFiles = new HashMap<String, byte[]>();

    public LocalBenchmarkData(Path benchmarkPath) {
        this.benchmarkPath = benchmarkPath;
    }

    @Override
    public InputStream readFile(String file) {
        Path path = Paths.get(file, new String[0]);
        if (!path.isAbsolute()) {
            path = this.benchmarkPath.getParent().resolve(file);
        }
        try {
            this.readFiles.put(file, Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new BenchmarkDefinitionException("Local file " + file + " (" + path.toAbsolutePath() + ") cannot be read.", e);
        }
        try {
            return new FileInputStream(path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new BenchmarkDefinitionException("Local file " + file + " (" + path.toAbsolutePath() + ") was not found.", e);
        }
    }

    @Override
    public Map<String, byte[]> files() {
        return this.readFiles;
    }
}

