/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.core.impl.SessionStatsConsumer;
import io.hyperfoil.core.impl.SimulationRunner;
import io.hyperfoil.core.impl.statistics.StatisticsCollector;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LocalSimulationRunner
extends SimulationRunner {
    private final StatisticsCollector.StatisticsConsumer statsConsumer;
    private final SessionStatsConsumer sessionPoolStatsConsumer;
    private final Lock statusLock = new ReentrantLock();
    private final Condition statusCondition = this.statusLock.newCondition();
    private long startTime;

    public LocalSimulationRunner(Benchmark benchmark) {
        this(benchmark, null, null);
    }

    public LocalSimulationRunner(Benchmark benchmark, StatisticsCollector.StatisticsConsumer statsConsumer, SessionStatsConsumer sessionPoolStatsConsumer) {
        super(benchmark, 0);
        this.statsConsumer = statsConsumer;
        this.sessionPoolStatsConsumer = sessionPoolStatsConsumer;
    }

    public void run() {
        if (this.benchmark.phases().isEmpty()) {
            throw new BenchmarkDefinitionException("No phases/scenarios have been defined");
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.init();
        this.openConnections((Handler<AsyncResult<Void>>)((Handler)result -> latch.countDown()));
        try {
            latch.await();
            this.exec();
            for (PhaseInstance phase : this.instances.values()) {
                if (phase.getError() == null) continue;
                throw new RuntimeException(phase.getError());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec() {
        long now;
        this.startTime = now = System.currentTimeMillis();
        do {
            PhaseInstance[] availablePhases;
            now = System.currentTimeMillis();
            for (PhaseInstance[] phase2 : this.instances.values()) {
                if (phase2.status() == PhaseInstance.Status.RUNNING && phase2.absoluteStartTime() + phase2.definition().duration() <= now) {
                    this.finishPhase(phase2.definition().name());
                }
                if (phase2.status() != PhaseInstance.Status.FINISHED) continue;
                if (phase2.definition().maxDuration() >= 0L && phase2.absoluteStartTime() + phase2.definition().maxDuration() <= now) {
                    this.terminatePhase(phase2.definition().name());
                    continue;
                }
                if (!phase2.definition().terminateAfterStrict().stream().map(this.instances::get).allMatch(p -> p.status().isTerminated())) continue;
                this.tryTerminatePhase(phase2.definition().name());
            }
            for (PhaseInstance phase3 : availablePhases = this.getAvailablePhases()) {
                this.startPhase(phase3.definition().name());
            }
            long nextPhaseStart = this.instances.values().stream().filter(phase -> phase.status() == PhaseInstance.Status.NOT_STARTED && phase.definition().startTime() >= 0L).mapToLong(phase -> this.startTime + phase.definition().startTime()).min().orElse(Long.MAX_VALUE);
            long nextPhaseFinish = this.instances.values().stream().filter(phase -> phase.status() == PhaseInstance.Status.RUNNING).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().duration()).min().orElse(Long.MAX_VALUE);
            long nextPhaseTerminate = this.instances.values().stream().filter(phase -> (phase.status() == PhaseInstance.Status.RUNNING || phase.status() == PhaseInstance.Status.FINISHED) && phase.definition().maxDuration() >= 0L).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().maxDuration()).min().orElse(Long.MAX_VALUE);
            long delay = Math.min(Math.min(nextPhaseStart, nextPhaseFinish), nextPhaseTerminate) - System.currentTimeMillis();
            if ((delay = Math.min(delay, 1000L)) <= 0L) continue;
            this.statusLock.lock();
            try {
                this.statusCondition.await(delay, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                for (PhaseInstance phase4 : this.instances.values()) {
                    this.terminatePhase(phase4.definition().name());
                }
                Thread.currentThread().interrupt();
            }
            finally {
                this.statusLock.unlock();
            }
        } while (this.instances.values().stream().anyMatch(phase -> phase.status() != PhaseInstance.Status.STATS_COMPLETE));
    }

    @Override
    protected CompletableFuture<Void> phaseChanged(Phase phase, PhaseInstance.Status status, boolean sessionLimitExceeded, Throwable error) {
        return super.phaseChanged(phase, status, sessionLimitExceeded, error).thenRun(() -> {
            if (status == PhaseInstance.Status.TERMINATED) {
                this.publishStats(phase);
                ((PhaseInstance)this.instances.get(phase.name)).setStatsComplete();
            }
            this.statusLock.lock();
            try {
                this.statusCondition.signal();
            }
            finally {
                this.statusLock.unlock();
            }
        });
    }

    private void publishStats(Phase phase) {
        if (this.statsConsumer != null) {
            StatisticsCollector collector = new StatisticsCollector(this.benchmark);
            this.visitStatistics(phase, collector);
            collector.visitStatistics(this.statsConsumer, null);
        }
        if (this.sessionPoolStatsConsumer != null) {
            this.visitSessionPoolStats(phase, this.sessionPoolStatsConsumer);
        }
    }

    private PhaseInstance[] getAvailablePhases() {
        return (PhaseInstance[])this.instances.values().stream().filter(phase -> phase.status() == PhaseInstance.Status.NOT_STARTED && this.startTime + phase.definition().startTime() <= System.currentTimeMillis() && phase.definition().startAfter().stream().allMatch(dep -> ((PhaseInstance)this.instances.get(dep)).status().isFinished()) && phase.definition().startAfterStrict().stream().allMatch(dep -> ((PhaseInstance)this.instances.get(dep)).status().isTerminated())).toArray(PhaseInstance[]::new);
    }
}

