/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.collection.ElasticPool;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.PhaseChangeHandler;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.Session;
import io.netty.util.concurrent.EventExecutorGroup;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.IntStream;

public abstract class PhaseInstanceImpl<D extends Phase>
implements PhaseInstance {
    protected static final Logger log = LoggerFactory.getLogger(PhaseInstanceImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    private static Map<Class<? extends Phase>, BiFunction<? extends Phase, Integer, PhaseInstance>> constructors = new HashMap<Class<? extends Phase>, BiFunction<? extends Phase, Integer, PhaseInstance>>();
    protected final D def;
    private final int agentThreads;
    private final int agentFirstThreadId;
    protected ElasticPool<Session> sessionPool;
    protected List<Session> sessionList;
    private PhaseChangeHandler phaseChangeHandler;
    protected volatile PhaseInstance.Status status = PhaseInstance.Status.NOT_STARTED;
    protected long absoluteStartTime;
    protected AtomicInteger activeSessions = new AtomicInteger(0);
    private volatile Throwable error;
    private volatile boolean sessionLimitExceeded;

    public static PhaseInstance newInstance(Phase def, int agentId) {
        BiFunction<? extends Phase, Integer, PhaseInstance> ctor = constructors.get(def.getClass());
        if (ctor == null) {
            throw new BenchmarkDefinitionException("Unknown phase type: " + def);
        }
        return ctor.apply(def, agentId);
    }

    protected PhaseInstanceImpl(D def, int agentId) {
        this.def = def;
        this.agentThreads = ((Phase)def).benchmark().threads(agentId);
        this.agentFirstThreadId = IntStream.range(0, agentId).map(id -> def.benchmark().threads(id)).sum();
    }

    public D definition() {
        return this.def;
    }

    @Override
    public PhaseInstance.Status status() {
        return this.status;
    }

    @Override
    public long absoluteStartTime() {
        return this.absoluteStartTime;
    }

    @Override
    public void start(EventExecutorGroup executorGroup) {
        assert (this.status == PhaseInstance.Status.NOT_STARTED) : "Status is " + this.status;
        this.status = PhaseInstance.Status.RUNNING;
        this.absoluteStartTime = System.currentTimeMillis();
        log.debug((Object)"{} changing status to RUNNING", new Object[]{((Phase)this.def).name});
        this.phaseChangeHandler.onChange((Phase)this.def, PhaseInstance.Status.RUNNING, false, this.error).thenRun(() -> this.proceed(executorGroup));
    }

    @Override
    public void finish() {
        assert (this.status == PhaseInstance.Status.RUNNING) : "Status is " + this.status;
        this.status = PhaseInstance.Status.FINISHED;
        log.debug((Object)"{} changing status to FINISHED", new Object[]{((Phase)this.def).name});
        Throwable error = null;
        this.phaseChangeHandler.onChange((Phase)this.def, PhaseInstance.Status.FINISHED, this.sessionLimitExceeded, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryTerminate() {
        assert (this.status.isFinished());
        if (this.activeSessions.compareAndSet(0, Integer.MIN_VALUE)) {
            this.setTerminated();
        } else if (this.sessionList != null && this.status == PhaseInstance.Status.TERMINATING) {
            List<Session> list = this.sessionList;
            synchronized (list) {
                for (int i = 0; i < this.sessionList.size(); ++i) {
                    Session session = this.sessionList.get(i);
                    if (!session.isActive()) continue;
                    session.proceed();
                }
            }
        }
    }

    @Override
    public void terminate() {
        if (this.status.ordinal() < PhaseInstance.Status.TERMINATED.ordinal()) {
            this.status = PhaseInstance.Status.TERMINATING;
        }
        log.debug((Object)"{} changing status to TERMINATING", new Object[]{((Phase)this.def).name});
        this.tryTerminate();
    }

    @Override
    public void setComponents(ElasticPool<Session> sessionPool, List<Session> sessionList, PhaseChangeHandler phaseChangeHandler) {
        this.sessionPool = sessionPool;
        this.sessionList = sessionList;
        this.phaseChangeHandler = phaseChangeHandler;
    }

    @Override
    public void notifyFinished(Session session) {
        if (session != null) {
            this.sessionPool.release(session);
        }
        int numActive = this.activeSessions.decrementAndGet();
        if (trace) {
            log.trace((Object)"#{} NotifyFinished, {} has {} active sessions", new Object[]{session == null ? -1 : session.uniqueId(), ((Phase)this.def).name, numActive});
        }
        if (numActive < 0) {
            throw new IllegalStateException(((Phase)this.def).name + " has " + numActive + " active sessions");
        }
        if (numActive == 0 && this.status.isFinished() && this.activeSessions.compareAndSet(0, Integer.MIN_VALUE)) {
            this.setTerminated();
        }
    }

    @Override
    public void setTerminated() {
        this.status = PhaseInstance.Status.TERMINATED;
        log.debug((Object)"{} changing status to TERMINATED", new Object[]{((Phase)this.def).name});
        this.phaseChangeHandler.onChange((Phase)this.def, this.status, false, this.error);
    }

    @Override
    public void fail(Throwable error) {
        this.error = error;
        this.terminate();
    }

    @Override
    public void setSessionLimitExceeded() {
        this.sessionLimitExceeded = true;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public int agentThreads() {
        return this.agentThreads;
    }

    @Override
    public int agentFirstThreadId() {
        return this.agentFirstThreadId;
    }

    @Override
    public void setStatsComplete() {
        if (this.status != PhaseInstance.Status.TERMINATED) {
            throw new IllegalStateException();
        }
        log.debug((Object)"{} changing status to STATS_COMPLETE", new Object[]{((Phase)this.def).name});
        this.status = PhaseInstance.Status.STATS_COMPLETE;
    }

    protected boolean startNewSession() {
        Session session;
        int numActive = this.activeSessions.incrementAndGet();
        if (numActive < 0) {
            return true;
        }
        if (trace) {
            log.trace((Object)"{} has {} active sessions", new Object[]{((Phase)this.def).name, numActive});
        }
        try {
            session = this.sessionPool.acquire();
        }
        catch (Throwable t) {
            log.error((Object)"Error during session acquisition", t);
            this.notifyFinished(null);
            return true;
        }
        if (session == null) {
            this.notifyFinished(null);
            return true;
        }
        session.start(this);
        return false;
    }

    static {
        constructors.put(Phase.AtOnce.class, AtOnce::new);
        constructors.put(Phase.Always.class, Always::new);
        constructors.put(Phase.RampRate.class, RampRate::new);
        constructors.put(Phase.ConstantRate.class, ConstantRate::new);
        constructors.put(Phase.Sequentially.class, Sequentially::new);
        constructors.put(Phase.Noop.class, Noop::new);
    }

    public static class Noop
    extends PhaseInstanceImpl<Phase.Noop> {
        protected Noop(Phase.Noop def, int agentId) {
            super(def, agentId);
        }

        @Override
        public void proceed(EventExecutorGroup executorGroup) {
        }

        @Override
        public void reserveSessions() {
        }
    }

    public static class Sequentially
    extends PhaseInstanceImpl<Phase.Sequentially> {
        private int counter = 0;

        public Sequentially(Phase.Sequentially def, int agentId) {
            super(def, agentId);
        }

        @Override
        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            this.startNewSession();
        }

        @Override
        public void reserveSessions() {
            this.sessionPool.reserve(1);
        }

        @Override
        public void notifyFinished(Session session) {
            if (++this.counter >= ((Phase.Sequentially)this.def).repeats) {
                this.status = PhaseInstance.Status.TERMINATING;
                log.debug((Object)"{} changing status to TERMINATING", new Object[]{((Phase.Sequentially)this.def).name});
                super.notifyFinished(session);
            } else {
                session.start(this);
            }
        }
    }

    public static class ConstantRate
    extends OpenModelPhase<Phase.ConstantRate> {
        private final double usersPerSec;

        public ConstantRate(Phase.ConstantRate def, int agentId) {
            super(def, agentId);
            this.usersPerSec = def.benchmark().slice(def.usersPerSec, agentId);
            this.nextScheduled = def.variance ? this.nextSessionRandomized() : 0.0;
        }

        @Override
        protected long nextSessionMetronome(long delta) {
            long required = (long)((double)delta * this.usersPerSec / 1000.0);
            this.nextScheduled = ((double)(1000L * (this.startedOrThrottledUsers + 1L)) + this.usersPerSec) / this.usersPerSec;
            return required;
        }

        @Override
        protected double nextSessionRandomized() {
            return this.nextScheduled + 1000.0 * -Math.log(Math.max(1.0E-20, this.random.nextDouble())) / this.usersPerSec;
        }
    }

    public static class RampRate
    extends OpenModelPhase<Phase.RampRate> {
        private final double initialUsersPerSec;
        private final double targetUsersPerSec;

        public RampRate(Phase.RampRate def, int agentId) {
            super(def, agentId);
            this.initialUsersPerSec = def.benchmark().slice(def.initialUsersPerSec, agentId);
            this.targetUsersPerSec = def.benchmark().slice(def.targetUsersPerSec, agentId);
            this.nextScheduled = def.variance ? this.nextSessionRandomized() : 0.0;
        }

        @Override
        protected long nextSessionMetronome(long delta) {
            double progress = (this.targetUsersPerSec - this.initialUsersPerSec) / (double)(((Phase.RampRate)this.def).duration * 1000L);
            long required = (long)((progress * (double)(delta + 1L) / 2.0 + this.initialUsersPerSec / 1000.0) * (double)delta);
            double bCoef = progress + this.initialUsersPerSec / 500.0;
            this.nextScheduled = Math.ceil((-bCoef + Math.sqrt(bCoef * bCoef + 8.0 * progress * (double)(this.startedOrThrottledUsers + 1L))) / (2.0 * progress));
            return required;
        }

        @Override
        protected double nextSessionRandomized() {
            double aCoef = this.targetUsersPerSec - this.initialUsersPerSec;
            if (aCoef < 1.0E-6) {
                return 1000.0 * -Math.log(Math.max(1.0E-20, this.random.nextDouble())) / this.initialUsersPerSec;
            }
            double bCoef = this.nextScheduled * (this.targetUsersPerSec - this.initialUsersPerSec) + this.initialUsersPerSec * (double)((Phase.RampRate)this.def).duration;
            double cCoef = (double)(((Phase.RampRate)this.def).duration * 1000L) * Math.log(this.random.nextDouble());
            return this.nextScheduled + (-bCoef + Math.sqrt(bCoef * bCoef - 4.0 * aCoef * cCoef)) / (2.0 * aCoef);
        }
    }

    protected static abstract class OpenModelPhase<P extends Phase.OpenModelPhase>
    extends PhaseInstanceImpl<P> {
        protected final int maxSessions;
        protected final Random random = new Random();
        protected double nextScheduled;
        protected AtomicLong throttledUsers = new AtomicLong(0L);
        protected long startedOrThrottledUsers = 0L;

        protected OpenModelPhase(P def, int agentId) {
            super(def, agentId);
            this.maxSessions = Math.max(1, ((Phase)def).benchmark().slice(((Phase.OpenModelPhase)def).maxSessions, agentId));
        }

        @Override
        public void proceed(EventExecutorGroup executorGroup) {
            if (this.status.isFinished()) {
                return;
            }
            long now = System.currentTimeMillis();
            long delta = now - this.absoluteStartTime;
            if (((Phase.OpenModelPhase)this.def).variance) {
                while ((double)delta > this.nextScheduled) {
                    if (this.startNewSession()) {
                        this.throttledUsers.incrementAndGet();
                    }
                    ++this.startedOrThrottledUsers;
                    this.nextScheduled = this.nextSessionRandomized();
                }
            } else {
                long required = this.nextSessionMetronome(delta);
                for (long i = required - this.startedOrThrottledUsers; i > 0L; --i) {
                    if (!this.startNewSession()) continue;
                    this.throttledUsers.addAndGet(i);
                    break;
                }
                this.startedOrThrottledUsers = Math.max(required, this.startedOrThrottledUsers);
            }
            long nextDelta = (long)Math.ceil(this.nextScheduled);
            if (trace) {
                log.trace((Object)"{}: {} after start, {} started ({} throttled), next user in {} ms", new Object[]{((Phase.OpenModelPhase)this.def).name, delta, this.startedOrThrottledUsers, this.throttledUsers.get(), nextDelta - delta});
            }
            executorGroup.schedule(() -> this.proceed(executorGroup), nextDelta - delta, TimeUnit.MILLISECONDS);
        }

        protected abstract long nextSessionMetronome(long var1);

        protected abstract double nextSessionRandomized();

        @Override
        public void reserveSessions() {
            log.debug((Object)"Phase {} reserving {} sessions", new Object[]{((Phase.OpenModelPhase)this.def).name, this.maxSessions});
            this.sessionPool.reserve(this.maxSessions);
        }

        @Override
        public void notifyFinished(Session session) {
            if (session != null && !this.status.isFinished()) {
                long throttled = this.throttledUsers.get();
                while (throttled != 0L) {
                    if (this.throttledUsers.compareAndSet(throttled, throttled - 1L)) {
                        session.start(this);
                        return;
                    }
                    throttled = this.throttledUsers.get();
                }
            }
            super.notifyFinished(session);
        }
    }

    public static class Always
    extends PhaseInstanceImpl<Phase.Always> {
        final int users;

        public Always(Phase.Always def, int agentId) {
            super(def, agentId);
            this.users = def.benchmark().slice(def.users, agentId);
        }

        @Override
        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            for (int i = 0; i < this.users; ++i) {
                this.startNewSession();
            }
        }

        @Override
        public void reserveSessions() {
            if (this.users > 0) {
                this.sessionPool.reserve(this.users);
            }
        }

        @Override
        public void notifyFinished(Session session) {
            if (this.status.isFinished() || session == null) {
                super.notifyFinished(session);
            } else {
                session.start(this);
            }
        }
    }

    public static class AtOnce
    extends PhaseInstanceImpl<Phase.AtOnce> {
        private final int users;

        public AtOnce(Phase.AtOnce def, int agentId) {
            super(def, agentId);
            this.users = def.benchmark().slice(def.users, agentId);
        }

        @Override
        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            for (int i = 0; i < this.users; ++i) {
                this.startNewSession();
            }
        }

        @Override
        public void reserveSessions() {
            if (this.users > 0) {
                this.sessionPool.reserve(this.users);
            }
        }
    }
}

