/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.PhaseChangeHandler;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SharedData;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.api.Plugin;
import io.hyperfoil.core.api.PluginRunData;
import io.hyperfoil.core.impl.ElasticPoolImpl;
import io.hyperfoil.core.impl.PhaseInstanceImpl;
import io.hyperfoil.core.impl.SessionStatsConsumer;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.session.SharedDataImpl;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.internal.Properties;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public class SimulationRunner {
    protected static final Logger log = LoggerFactory.getLogger(SimulationRunner.class);
    private static final Clock DEFAULT_CLOCK = Clock.systemDefaultZone();
    protected final Benchmark benchmark;
    protected final int agentId;
    protected final Map<String, PhaseInstance> instances = new HashMap<String, PhaseInstance>();
    protected final List<Session> sessions = new ArrayList<Session>();
    private final Map<String, SharedResources> sharedResources = new HashMap<String, SharedResources>();
    protected final NioEventLoopGroup eventLoopGroup;
    protected final EventLoop[] executors;
    private final Queue<Phase> toPrune;
    private final PluginRunData[] runData;
    private PhaseChangeHandler phaseChangeHandler;
    private Consumer<Throwable> errorHandler;
    private boolean isDepletedMessageQuietened;
    private Thread jitterWatchdog;

    public SimulationRunner(Benchmark benchmark, int agentId) {
        this.eventLoopGroup = new NioEventLoopGroup(benchmark.threads(agentId));
        this.executors = (EventLoop[])StreamSupport.stream(this.eventLoopGroup.spliterator(), false).map(EventLoop.class::cast).toArray(EventLoop[]::new);
        this.benchmark = benchmark;
        this.agentId = agentId;
        this.toPrune = new ArrayBlockingQueue<Phase>(benchmark.phases().size());
        this.runData = (PluginRunData[])benchmark.plugins().stream().map(config -> Plugin.lookup(config).createRunData(benchmark, this.executors, agentId)).toArray(PluginRunData[]::new);
    }

    public void setPhaseChangeHandler(PhaseChangeHandler phaseChangeHandler) {
        this.phaseChangeHandler = phaseChangeHandler;
    }

    public void setErrorHandler(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void init() {
        for (Phase def : this.benchmark.phases()) {
            SharedResources sharedResources;
            if (def.sharedResources == null) {
                sharedResources = SharedResources.NONE;
            } else {
                sharedResources = this.sharedResources.get(def.sharedResources);
                if (sharedResources == null) {
                    sharedResources = new SharedResources(this.executors.length);
                    sharedResources.sessions = new ArrayList<Session>();
                    ArrayList<Session> phaseSessions = sharedResources.sessions;
                    SessionStatistics[] statistics = sharedResources.statistics;
                    SharedData[] data = sharedResources.data;
                    Supplier<Session> sessionSupplier = () -> {
                        Session session;
                        int executorId;
                        List<Session> list = this.sessions;
                        synchronized (list) {
                            executorId = phaseSessions.size() % this.executors.length;
                            session = SessionFactory.create(def.scenario, this.agentId, executorId, this.sessions.size());
                            this.sessions.add(session);
                            phaseSessions.add(session);
                        }
                        session.attach((EventExecutor)this.executors[executorId], data[executorId], statistics[executorId]);
                        for (int i = 0; i < this.runData.length; ++i) {
                            this.runData[i].initSession(session, executorId, def.scenario, DEFAULT_CLOCK);
                        }
                        session.reserve(def.scenario);
                        return session;
                    };
                    SharedResources finalSharedResources = sharedResources;
                    sharedResources.sessionPool = new ElasticPoolImpl<Session>(sessionSupplier, () -> {
                        if (!this.isDepletedMessageQuietened) {
                            log.warn((Object)"Pool depleted, throttling execution! Enable trace logging to see subsequent pool depletion messages.");
                            this.isDepletedMessageQuietened = true;
                        } else {
                            log.trace((Object)"Pool depleted, throttling execution!");
                        }
                        finalSharedResources.currentPhase.setSessionLimitExceeded();
                        return null;
                    });
                    this.sharedResources.put(def.sharedResources, sharedResources);
                }
            }
            PhaseInstance phase = PhaseInstanceImpl.newInstance(def, this.agentId);
            this.instances.put(def.name(), phase);
            phase.setComponents(sharedResources.sessionPool, sharedResources.sessions, this::phaseChanged);
            phase.reserveSessions();
        }
        System.gc();
        this.jitterWatchdog = new Thread(this::observeJitter, "jitter-watchdog");
        this.jitterWatchdog.setDaemon(true);
        this.jitterWatchdog.start();
    }

    public void openConnections(Handler<AsyncResult<Void>> handler) {
        ArrayList futures = new ArrayList();
        for (PluginRunData plugin : this.runData) {
            plugin.openConnections(futures::add);
        }
        CompositeFuture composite = CompositeFuture.join(futures);
        composite.onComplete(result -> {
            if (result.failed()) {
                log.error((Object)"One of the HTTP client pools failed to start.");
            }
            handler.handle((Object)result.mapEmpty());
        });
    }

    private void observeJitter() {
        long period = Properties.getLong("io.hyperfoil.jitter.watchdog.period", 50L);
        long threshold = Properties.getLong("io.hyperfoil.jitter.watchdog.threshold", 100L);
        long lastTimestamp = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted, terminating jitter watchdog");
                return;
            }
            long currentTimestamp = System.nanoTime();
            long delay = TimeUnit.NANOSECONDS.toMillis(currentTimestamp - lastTimestamp);
            if (delay > threshold) {
                log.error((Object)"Jitter watchdog was not invoked for {} ms (threshold is {} ms); please check your GC settings.", new Object[]{delay, threshold});
                if (this.errorHandler != null) {
                    this.errorHandler.accept(new BenchmarkExecutionException("Jitter watchdog was not invoked for " + delay + " ms; check GC settings."));
                }
            }
            lastTimestamp = currentTimestamp;
        }
    }

    protected CompletableFuture<Void> phaseChanged(Phase phase, PhaseInstance.Status status, boolean sessionLimitExceeded, Throwable error) {
        if (status == PhaseInstance.Status.TERMINATED) {
            return this.terminateStatistics(phase).whenComplete((nil, e) -> this.notifyAndScheduleForPruning(phase, status, sessionLimitExceeded, error != null ? error : e));
        }
        this.notifyAndScheduleForPruning(phase, status, sessionLimitExceeded, error);
        return Util.COMPLETED_VOID_FUTURE;
    }

    private CompletableFuture<Void> terminateStatistics(Phase phase) {
        SharedResources resources = this.sharedResources.get(phase.sharedResources);
        if (resources == null || resources.statistics == null) {
            return Util.COMPLETED_VOID_FUTURE;
        }
        ArrayList futures = new ArrayList(this.executors.length);
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.executors.length; ++i) {
            SessionStatistics statistics = resources.statistics[i];
            if (this.executors[i].inEventLoop()) {
                this.applyToPhase(statistics, phase, now, Statistics::end);
                continue;
            }
            CompletableFuture cf = new CompletableFuture();
            futures.add(cf);
            this.executors[i].execute(() -> {
                try {
                    this.applyToPhase(statistics, phase, now, Statistics::end);
                    cf.complete(null);
                }
                catch (Throwable t) {
                    cf.completeExceptionally(t);
                }
            });
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void notifyAndScheduleForPruning(Phase phase, PhaseInstance.Status status, boolean sessionLimitExceeded, Throwable error) {
        if (this.phaseChangeHandler != null) {
            this.phaseChangeHandler.onChange(phase, status, sessionLimitExceeded, error);
        }
        if (status == PhaseInstance.Status.TERMINATED) {
            this.toPrune.add(phase);
        }
    }

    public void shutdown() {
        if (this.jitterWatchdog != null) {
            this.jitterWatchdog.interrupt();
        }
        for (PluginRunData plugin : this.runData) {
            plugin.shutdown();
        }
        this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSessions(Consumer<Session> consumer) {
        List<Session> list = this.sessions;
        synchronized (list) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                Session session = this.sessions.get(i);
                consumer.accept(session);
            }
        }
    }

    public void visitStatistics(Consumer<SessionStatistics> consumer) {
        Phase phase;
        for (SharedResources sharedResources : this.sharedResources.values()) {
            if (sharedResources.currentPhase == null) continue;
            for (SessionStatistics statistics : sharedResources.statistics) {
                consumer.accept(statistics);
            }
        }
        while ((phase = this.toPrune.poll()) != null) {
            Phase phase2 = phase;
            for (SharedResources sharedResources : this.sharedResources.values()) {
                if (sharedResources.statistics == null) continue;
                SessionStatistics[] sessionStatistics = sharedResources.statistics;
                for (int i = 0; i < sessionStatistics.length; ++i) {
                    SessionStatistics statistics = sessionStatistics[i];
                    this.executors[i].execute(() -> statistics.prune(phase2));
                }
            }
        }
    }

    public void visitStatistics(Phase phase, Consumer<SessionStatistics> consumer) {
        SharedResources sharedResources = this.sharedResources.get(phase.sharedResources);
        if (sharedResources == null || sharedResources.statistics == null) {
            return;
        }
        for (SessionStatistics statistics : sharedResources.statistics) {
            consumer.accept(statistics);
        }
    }

    public void visitSessionPoolStats(SessionStatsConsumer consumer) {
        for (SharedResources sharedResources : this.sharedResources.values()) {
            if (sharedResources.currentPhase == null) continue;
            int minUsed = sharedResources.sessionPool.minUsed();
            int maxUsed = sharedResources.sessionPool.maxUsed();
            sharedResources.sessionPool.resetStats();
            if (minUsed > maxUsed || maxUsed == 0) continue;
            consumer.accept(sharedResources.currentPhase.definition().name(), minUsed, maxUsed);
        }
    }

    public void visitSessionPoolStats(Phase phase, SessionStatsConsumer consumer) {
        SharedResources sharedResources = this.sharedResources.get(phase.sharedResources);
        if (sharedResources != null) {
            int minUsed = sharedResources.sessionPool.minUsed();
            int maxUsed = sharedResources.sessionPool.maxUsed();
            sharedResources.sessionPool.resetStats();
            if (minUsed < maxUsed) {
                consumer.accept(phase.name(), minUsed, maxUsed);
            }
        }
    }

    public void startPhase(String phase) {
        PhaseInstance phaseInstance = this.instances.get(phase);
        SharedResources sharedResources = this.sharedResources.get(phaseInstance.definition().sharedResources);
        if (sharedResources != null) {
            sharedResources.currentPhase = phaseInstance;
            if (sharedResources.statistics != null) {
                long now = System.currentTimeMillis();
                for (int i = 0; i < this.executors.length; ++i) {
                    SessionStatistics statistics = sharedResources.statistics[i];
                    this.executors[i].execute(() -> this.applyToPhase(statistics, phaseInstance.definition(), now, Statistics::start));
                }
            }
        }
        phaseInstance.start((EventExecutorGroup)this.eventLoopGroup);
    }

    private void applyToPhase(SessionStatistics statistics, Phase phase, long now, BiConsumer<Statistics, Long> f) {
        for (int j = 0; j < statistics.size(); ++j) {
            if (statistics.phase(j) != phase) continue;
            for (Statistics s : statistics.stats(j).values()) {
                f.accept(s, now);
            }
        }
    }

    public void finishPhase(String phase) {
        this.instances.get(phase).finish();
    }

    public void tryTerminatePhase(String phase) {
        this.instances.get(phase).tryTerminate();
    }

    public void terminatePhase(String phase) {
        this.instances.get(phase).terminate();
    }

    public List<String> listConnections() {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginRunData plugin : this.runData) {
            plugin.listConnections(list::add);
        }
        return list;
    }

    private static class SharedResources {
        static final SharedResources NONE = new SharedResources(0);
        PhaseInstance currentPhase;
        ElasticPoolImpl<Session> sessionPool;
        List<Session> sessions;
        SessionStatistics[] statistics;
        SharedData[] data;

        SharedResources(int executorCount) {
            this.statistics = new SessionStatistics[executorCount];
            this.data = new SharedData[executorCount];
            for (int executorId = 0; executorId < executorCount; ++executorId) {
                this.statistics[executorId] = new SessionStatistics();
                this.data[executorId] = new SharedDataImpl();
            }
        }
    }
}

