/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.statistics;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.core.util.CountDown;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class StatisticsCollector
implements Consumer<SessionStatistics> {
    private static final Logger log = LoggerFactory.getLogger(StatisticsCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final Phase[] phases;
    protected IntObjectMap<Map<String, IntObjectMap<StatisticsSnapshot>>> aggregated = new IntObjectHashMap();

    public StatisticsCollector(Benchmark benchmark) {
        this.phases = benchmark.phasesById();
    }

    @Override
    public void accept(SessionStatistics statistics) {
        for (int i = 0; i < statistics.size(); ++i) {
            int phaseAndStepId = (statistics.phase(i).id() << 16) + statistics.step(i);
            HashMap<String, IntObjectMap> metricMap = (HashMap<String, IntObjectMap>)this.aggregated.get(phaseAndStepId);
            if (metricMap == null) {
                metricMap = new HashMap<String, IntObjectMap>();
                this.aggregated.put(phaseAndStepId, metricMap);
            }
            for (Map.Entry<String, Statistics> entry : statistics.stats(i).entrySet()) {
                String metric = entry.getKey();
                IntObjectMap snapshots = metricMap.computeIfAbsent(metric, k -> new IntObjectHashMap());
                entry.getValue().visitSnapshots(snapshot -> {
                    assert (snapshot.sequenceId >= 0);
                    StatisticsSnapshot existing = (StatisticsSnapshot)snapshots.get(snapshot.sequenceId);
                    if (existing == null) {
                        existing = new StatisticsSnapshot();
                        existing.sequenceId = snapshot.sequenceId;
                        snapshots.put(snapshot.sequenceId, (Object)existing);
                    }
                    snapshot.addInto(existing);
                });
            }
        }
    }

    public void visitStatistics(StatisticsConsumer consumer, CountDown countDown) {
        Iterator it1 = this.aggregated.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry entry = (Map.Entry)it1.next();
            int phaseAndStepId = (Integer)entry.getKey();
            Map metricMap = (Map)entry.getValue();
            Iterator it2 = metricMap.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry se = it2.next();
                String metric = (String)se.getKey();
                IntObjectMap snapshots = (IntObjectMap)se.getValue();
                Iterator it3 = snapshots.entries().iterator();
                while (it3.hasNext()) {
                    IntObjectMap.PrimitiveEntry pe = (IntObjectMap.PrimitiveEntry)it3.next();
                    if (((StatisticsSnapshot)pe.value()).isEmpty()) {
                        it3.remove();
                        continue;
                    }
                    consumer.accept(this.phases[phaseAndStepId >> 16], phaseAndStepId & 0xFFFF, metric, (StatisticsSnapshot)pe.value(), countDown);
                    ((StatisticsSnapshot)pe.value()).reset();
                }
                if (!snapshots.isEmpty()) continue;
                it2.remove();
            }
            if (!metricMap.isEmpty()) continue;
            it1.remove();
        }
    }

    public static interface StatisticsConsumer {
        public void accept(Phase var1, int var2, String var3, StatisticsSnapshot var4, CountDown var5);
    }
}

