/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;

public abstract class AbstractParser<T, S>
implements Parser<T> {
    Map<String, Parser<S>> subBuilders = new HashMap<String, Parser<S>>();

    public void callSubBuilders(Context ctx, S target) throws ParserException {
        ctx.parseMapping(target, this::getSubBuilder);
    }

    private Parser<S> getSubBuilder(ScalarEvent event) throws ParserException {
        Parser<S> builder = this.subBuilders.get(event.getValue());
        if (builder == null) {
            throw new ParserException((Event)event, "Invalid configuration label: '" + event.getValue() + "', expected one of " + this.subBuilders.keySet());
        }
        return builder;
    }

    protected void register(String property, Parser<S> parser) {
        Parser<S> prev = this.subBuilders.put(property, parser);
        assert (prev == null);
    }
}

