/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.MappingListBuilder;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.PartialBuilder;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.builders.ServiceLoadedContract;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.StepParser;
import io.hyperfoil.core.util.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class BaseReflectionParser {
    protected void invokeWithParameters(Context ctx, Object target, ScalarEvent keyEvent) throws ParserException {
        Event defEvent = ctx.peek();
        String key = keyEvent.getValue();
        if (defEvent instanceof MappingEndEvent) {
            Object builder = this.invokeWithNoParams(target, keyEvent, key);
            if (builder instanceof ServiceLoadedContract) {
                ((ServiceLoadedContract)builder).complete();
            }
        } else if (defEvent instanceof ScalarEvent) {
            String value = ((ScalarEvent)defEvent).getValue();
            if (value != null && !value.isEmpty()) {
                this.invokeWithSingleParam(target, keyEvent, key, defEvent, value);
            } else {
                Object builder = this.invokeWithNoParams(target, keyEvent, key);
                if (builder instanceof ServiceLoadedContract) {
                    ((ServiceLoadedContract)builder).complete();
                }
            }
            ctx.consumePeeked(defEvent);
        } else if (defEvent instanceof MappingStartEvent) {
            Object builder = this.invokeWithNoParams(target, keyEvent, key);
            ctx.consumePeeked(defEvent);
            if (builder instanceof ServiceLoadedContract) {
                ServiceLoadedContract serviceLoadedContract = (ServiceLoadedContract)builder;
                this.applyMapping(ctx, serviceLoadedContract.builder());
                serviceLoadedContract.complete();
            } else if (builder instanceof ServiceLoadedBuilderProvider) {
                ScalarEvent nameEvent = ctx.expectEvent(ScalarEvent.class);
                this.fillSLBP(ctx, nameEvent, (ServiceLoadedBuilderProvider)builder);
                ctx.expectEvent(MappingEndEvent.class);
            } else {
                if (builder instanceof MappingListBuilder) {
                    builder = ((MappingListBuilder)builder).addItem();
                }
                this.applyMapping(ctx, builder);
            }
        } else if (defEvent instanceof SequenceStartEvent) {
            Object builder = this.invokeWithNoParams(target, keyEvent, key);
            ServiceLoadedContract slc = null;
            if (builder instanceof ServiceLoadedContract) {
                slc = (ServiceLoadedContract)builder;
                builder = slc.builder();
            }
            if (builder instanceof BaseSequenceBuilder) {
                ctx.parseList((BaseSequenceBuilder)builder, StepParser.instance());
            } else if (builder instanceof ServiceLoadedBuilderProvider) {
                Event itemEvent;
                ctx.consumePeeked(defEvent);
                while (ctx.hasNext() && !((itemEvent = ctx.next()) instanceof SequenceEndEvent)) {
                    if (itemEvent instanceof ScalarEvent) {
                        String name = ((ScalarEvent)itemEvent).getValue();
                        ServiceLoadedBuilderProvider provider = (ServiceLoadedBuilderProvider)builder;
                        try {
                            provider.forName(name, null).complete();
                            continue;
                        }
                        catch (BenchmarkDefinitionException e) {
                            throw new ParserException(itemEvent, "Failed to instantiate service-loaded builder " + name, e);
                        }
                    }
                    if (itemEvent instanceof MappingStartEvent) {
                        ScalarEvent nameEvent = ctx.expectEvent(ScalarEvent.class);
                        this.fillSLBP(ctx, nameEvent, (ServiceLoadedBuilderProvider)builder);
                        ctx.expectEvent(MappingEndEvent.class);
                        continue;
                    }
                    throw ctx.unexpectedEvent(defEvent);
                }
            } else {
                Event itemEvent;
                ctx.consumePeeked(defEvent);
                MappingListBuilder mlb = null;
                if (builder instanceof MappingListBuilder) {
                    mlb = (MappingListBuilder)builder;
                }
                while (ctx.hasNext() && !((itemEvent = ctx.next()) instanceof SequenceEndEvent)) {
                    if (mlb != null) {
                        builder = mlb.addItem();
                    }
                    if (itemEvent instanceof ScalarEvent) {
                        if (builder instanceof ListBuilder) {
                            ((ListBuilder)builder).nextItem(((ScalarEvent)itemEvent).getValue());
                            continue;
                        }
                        this.invokeWithParameters(ctx, builder, (ScalarEvent)itemEvent);
                        continue;
                    }
                    if (itemEvent instanceof MappingStartEvent) {
                        this.applyMapping(ctx, builder);
                        continue;
                    }
                    throw ctx.unexpectedEvent(itemEvent);
                }
            }
            if (slc != null) {
                slc.complete();
            }
        }
    }

    protected void fillSLBP(Context ctx, ScalarEvent nameEvent, ServiceLoadedBuilderProvider<?> provider) throws ParserException {
        ServiceLoadedContract slc;
        Event builderEvent = ctx.next();
        String param = null;
        if (builderEvent instanceof ScalarEvent) {
            param = ((ScalarEvent)builderEvent).getValue();
        }
        try {
            slc = provider.forName(nameEvent.getValue(), param);
        }
        catch (BenchmarkDefinitionException e) {
            throw new ParserException((Event)nameEvent, "Failed to instantiate service-loaded builder " + nameEvent.getValue(), e);
        }
        if (builderEvent instanceof MappingStartEvent) {
            this.applyMapping(ctx, slc.builder());
        } else if (!(builderEvent instanceof ScalarEvent)) {
            throw ctx.unexpectedEvent(builderEvent);
        }
        slc.complete();
    }

    private void invokeWithSingleParam(Object target, ScalarEvent keyEvent, String key, Event valueEvent, String value) throws ParserException {
        if (target instanceof PairBuilder) {
            PairBuilder builder = (PairBuilder)target;
            this.acceptPair(builder, key, value, valueEvent);
            return;
        }
        Invocable invocable = this.findMethod((Event)keyEvent, target, key, 1);
        if (invocable.method != null) {
            try {
                if (invocable.method.getParameterCount() == 1) {
                    Object param = this.convert(valueEvent, value, invocable.method.getParameterTypes()[0]);
                    invocable.method.invoke(invocable.targetSupplier.get(), param);
                }
                assert (invocable.method.getParameterCount() == 0);
                Object builder = invocable.method.invoke(invocable.targetSupplier.get(), new Object[0]);
                ((InitFromParam)builder).init(value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw this.cannotCreate(keyEvent, e);
            }
        } else if (target instanceof ServiceLoadedBuilderProvider.Owner) {
            this.getLoadedBuilder((ServiceLoadedBuilderProvider.Owner)target, keyEvent, key, value, invocable.exception).complete();
        } else {
            throw invocable.exception;
        }
    }

    private void acceptPair(PairBuilder builder, String key, String value, Event valueEvent) throws ParserException {
        Object param = this.convert(valueEvent, value, builder.valueType());
        builder.accept(key, param);
    }

    private ServiceLoadedContract getLoadedBuilder(ServiceLoadedBuilderProvider.Owner<?> target, ScalarEvent keyEvent, String key, String value, ParserException exception) throws ParserException {
        ServiceLoadedContract serviceLoadedContract;
        try {
            serviceLoadedContract = target.serviceLoaded().forName(key, value);
        }
        catch (BenchmarkDefinitionException e) {
            ParserException pe = new ParserException((Event)keyEvent, "Cannot find any step matching name '" + key + "'", e);
            pe.addSuppressed(exception);
            throw pe;
        }
        return serviceLoadedContract;
    }

    protected Object invokeWithNoParams(Object target, ScalarEvent keyEvent, String key) throws ParserException {
        if (target instanceof PartialBuilder) {
            return ((PartialBuilder)target).withKey(key);
        }
        Invocable invocable = this.findMethod((Event)keyEvent, target, key, 0);
        if (invocable.method != null) {
            try {
                return invocable.method.invoke(invocable.targetSupplier.get(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw this.cannotCreate(keyEvent, e);
            }
        }
        if (target instanceof ServiceLoadedBuilderProvider.Owner) {
            return this.getLoadedBuilder((ServiceLoadedBuilderProvider.Owner)target, keyEvent, key, null, invocable.exception);
        }
        throw invocable.exception;
    }

    private void applyMapping(Context ctx, Object builder) throws ParserException {
        Event event;
        while (ctx.hasNext() && !((event = ctx.next()) instanceof MappingEndEvent)) {
            if (event instanceof ScalarEvent) {
                this.invokeWithParameters(ctx, builder, (ScalarEvent)event);
                continue;
            }
            throw ctx.unexpectedEvent(event);
        }
    }

    private Invocable findMethod(Event event, Object target, String name, int params) {
        ArrayList<Invocable> matchingName = new ArrayList<Invocable>();
        ArrayDeque<Invocable> todo = new ArrayDeque<Invocable>();
        HashSet visited = new HashSet();
        todo.add(new Invocable(target.getClass(), () -> target, null));
        while (!todo.isEmpty()) {
            Invocable inv2 = (Invocable)todo.poll();
            visited.add(inv2.builderType);
            for (Method method : inv2.builderType.getMethods()) {
                if (!method.getName().equals(name)) continue;
                matchingName.add(new Invocable(inv2.builderType, inv2.targetSupplier, method));
            }
            for (AccessibleObject accessibleObject : inv2.builderType.getFields()) {
                if (!accessibleObject.isAnnotationPresent(Embed.class) || visited.contains(((Field)accessibleObject).getType()) || ((Field)accessibleObject).getType().isPrimitive() || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                todo.add(new Invocable(((Field)accessibleObject).getType(), () -> BaseReflectionParser.lambda$findMethod$1((Field)accessibleObject, inv2), null));
            }
            for (AccessibleObject accessibleObject : inv2.builderType.getMethods()) {
                if (!accessibleObject.isAnnotationPresent(Embed.class) || visited.contains(((Method)accessibleObject).getReturnType()) || ((Method)accessibleObject).getParameterCount() > 0 || Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                todo.add(new Invocable(((Method)accessibleObject).getReturnType(), () -> BaseReflectionParser.lambda$findMethod$2((Method)accessibleObject, inv2), null));
            }
        }
        Invocable[] candidates = (Invocable[])matchingName.stream().filter(inv -> inv.method.getParameterCount() == params).filter(inv -> Stream.of(inv.method.getParameterTypes()).allMatch(Util::isParamConvertible)).toArray(Invocable[]::new);
        if (params == 1 && candidates.length == 0) {
            candidates = (Invocable[])matchingName.stream().filter(inv -> InitFromParam.class.isAssignableFrom(inv.method.getReturnType())).toArray(Invocable[]::new);
        }
        if (candidates.length == 0) {
            return new Invocable(new ParserException(event, "Cannot find method '" + name + "' on '" + target + "'"));
        }
        if (candidates.length == 1) {
            return candidates[0];
        }
        return new Invocable(new ParserException(event, "Ambiguous candidates for '" + name + "' on '" + target + "': " + Arrays.asList(candidates)));
    }

    private Object convert(Event event, String str, Class<?> type) throws ParserException {
        if (type == String.class || type == CharSequence.class || type == Object.class) {
            return str;
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(str);
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(str);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(str);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(str);
        }
        if (type.isEnum()) {
            return this.parseEnum(str, type);
        }
        throw new ParserException(event, "Cannot convert " + str + " to " + type);
    }

    private Enum parseEnum(String str, Class<?> type) {
        return Enum.valueOf(type, str);
    }

    private ParserException cannotCreate(ScalarEvent event, Exception exception) {
        return new ParserException((Event)event, "Cannot create step/builder '" + event.getValue() + "'", exception);
    }

    private static /* synthetic */ Object lambda$findMethod$2(Method m, Invocable inv) {
        try {
            return m.invoke(inv.targetSupplier.get(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BenchmarkDefinitionException("Cannot access " + inv.builderType.getName() + "." + m.getName(), e);
        }
    }

    private static /* synthetic */ Object lambda$findMethod$1(Field f, Invocable inv) {
        try {
            return f.get(inv.targetSupplier.get());
        }
        catch (IllegalAccessException e) {
            throw new BenchmarkDefinitionException("Cannot access " + inv.builderType.getName() + "." + f.getName(), e);
        }
    }

    private static class Invocable {
        final Class<?> builderType;
        final Supplier<Object> targetSupplier;
        final Method method;
        final ParserException exception;

        private Invocable(Class<?> builderType, Supplier<Object> targetSupplier, Method method) {
            this.builderType = builderType;
            this.targetSupplier = targetSupplier;
            this.method = method;
            this.exception = null;
        }

        private Invocable(ParserException exception) {
            this.builderType = null;
            this.targetSupplier = null;
            this.method = null;
            this.exception = exception;
        }
    }
}

